/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConversionService
implements ConfigurableConversionService {
    private static final GenericConverter NO_OP_CONVERTER = new NoOpConverter("NO_OP");
    private static final GenericConverter NO_MATCH = new NoOpConverter("NO_MATCH");
    private final Converters converters = new Converters();
    private final Map<ConverterCacheKey, GenericConverter> converterCache = new ConcurrentHashMap<ConverterCacheKey, GenericConverter>();

    @Override
    public void addConverter(Converter<?, ?> converter) {
        GenericConverter.ConvertiblePair typeInfo = this.getRequiredTypeInfo(converter, Converter.class);
        Assert.notNull(typeInfo, "Unable to the determine sourceType <S> and targetType <T> which your Converter<S, T> converts between; declare these generic types.");
        this.addConverter(new ConverterAdapter(typeInfo, converter));
    }

    @Override
    public void addConverter(Class<?> sourceType, Class<?> targetType, Converter<?, ?> converter) {
        GenericConverter.ConvertiblePair typeInfo = new GenericConverter.ConvertiblePair(sourceType, targetType);
        this.addConverter(new ConverterAdapter(typeInfo, converter));
    }

    @Override
    public void addConverter(GenericConverter converter) {
        this.converters.add(converter);
        this.invalidateCache();
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> converterFactory) {
        GenericConverter.ConvertiblePair typeInfo = this.getRequiredTypeInfo(converterFactory, ConverterFactory.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetRangeType R which your ConverterFactory<S, R> converts between; declare these generic types.");
        }
        this.addConverter(new ConverterFactoryAdapter(typeInfo, converterFactory));
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.converters.remove(sourceType, targetType);
        this.invalidateCache();
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(targetType, "The targetType to convert to cannot be null");
        return this.canConvert(sourceType != null ? TypeDescriptor.valueOf(sourceType) : null, TypeDescriptor.valueOf(targetType));
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull(targetType, "The targetType to convert to cannot be null");
        if (sourceType == null) {
            return true;
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        return converter != null;
    }

    public boolean canBypassConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull(targetType, "The targetType to convert to cannot be null");
        if (sourceType == null) {
            return true;
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        return converter == NO_OP_CONVERTER;
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        Assert.notNull(targetType, "The targetType to convert to cannot be null");
        return (T)this.convert(source, TypeDescriptor.forObject(source), TypeDescriptor.valueOf(targetType));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull(targetType, "The targetType to convert to cannot be null");
        if (sourceType == null) {
            Assert.isTrue(source == null, "The source must be [null] if sourceType == [null]");
            return this.handleResult(sourceType, targetType, this.convertNullSource(sourceType, targetType));
        }
        if (source != null && !sourceType.getObjectType().isInstance(source)) {
            throw new IllegalArgumentException("The source to convert from must be an instance of " + sourceType + "; instead it was a " + source.getClass().getName());
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        if (converter != null) {
            Object result = ConversionUtils.invokeConverter(converter, source, sourceType, targetType);
            return this.handleResult(sourceType, targetType, result);
        }
        return this.handleConverterNotFound(source, sourceType, targetType);
    }

    public Object convert(Object source, TypeDescriptor targetType) {
        return this.convert(source, TypeDescriptor.forObject(source), targetType);
    }

    public String toString() {
        return this.converters.toString();
    }

    protected Object convertNullSource(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return null;
    }

    protected GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        ConverterCacheKey key = new ConverterCacheKey(sourceType, targetType);
        GenericConverter converter = this.converterCache.get(key);
        if (converter != null) {
            return converter != NO_MATCH ? converter : null;
        }
        converter = this.converters.find(sourceType, targetType);
        if (converter == null) {
            converter = this.getDefaultConverter(sourceType, targetType);
        }
        if (converter != null) {
            this.converterCache.put(key, converter);
            return converter;
        }
        this.converterCache.put(key, NO_MATCH);
        return null;
    }

    protected GenericConverter getDefaultConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return sourceType.isAssignableTo(targetType) ? NO_OP_CONVERTER : null;
    }

    private GenericConverter.ConvertiblePair getRequiredTypeInfo(Object converter, Class<?> genericIfc) {
        Class[] args = GenericTypeResolver.resolveTypeArguments(converter.getClass(), genericIfc);
        return args != null ? new GenericConverter.ConvertiblePair(args[0], args[1]) : null;
    }

    private void invalidateCache() {
        this.converterCache.clear();
    }

    private Object handleConverterNotFound(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
            return source;
        }
        if (sourceType.isAssignableTo(targetType) && targetType.getObjectType().isInstance(source)) {
            return source;
        }
        throw new ConverterNotFoundException(sourceType, targetType);
    }

    private Object handleResult(TypeDescriptor sourceType, TypeDescriptor targetType, Object result) {
        if (result == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
        }
        return result;
    }

    private void assertNotPrimitiveTargetType(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.isPrimitive()) {
            throw new ConversionFailedException(sourceType, targetType, null, new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpConverter
    implements GenericConverter {
        private String name;

        public NoOpConverter(String name) {
            this.name = name;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return null;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ConvertersForPair {
        private final LinkedList<GenericConverter> converters = new LinkedList();

        private ConvertersForPair() {
        }

        public void add(GenericConverter converter) {
            this.converters.addFirst(converter);
        }

        public GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
            for (GenericConverter converter : this.converters) {
                if (converter instanceof ConditionalGenericConverter && !((ConditionalGenericConverter)converter).matches(sourceType, targetType)) continue;
                return converter;
            }
            return null;
        }

        public String toString() {
            return StringUtils.collectionToCommaDelimitedString(this.converters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Converters {
        private static final Set<Class<?>> IGNORED_CLASSES;
        private final Set<GenericConverter> globalConverters = new LinkedHashSet<GenericConverter>();
        private final Map<GenericConverter.ConvertiblePair, ConvertersForPair> converters = new LinkedHashMap<GenericConverter.ConvertiblePair, ConvertersForPair>(36);

        private Converters() {
        }

        public void add(GenericConverter converter) {
            Set<GenericConverter.ConvertiblePair> convertibleTypes = converter.getConvertibleTypes();
            if (convertibleTypes == null) {
                Assert.state(converter instanceof ConditionalConverter, "Only conditional converters may return null convertible types");
                this.globalConverters.add(converter);
            } else {
                for (GenericConverter.ConvertiblePair convertiblePair : convertibleTypes) {
                    ConvertersForPair convertersForPair = this.getMatchableConverters(convertiblePair);
                    convertersForPair.add(converter);
                }
            }
        }

        private ConvertersForPair getMatchableConverters(GenericConverter.ConvertiblePair convertiblePair) {
            ConvertersForPair convertersForPair = this.converters.get(convertiblePair);
            if (convertersForPair == null) {
                convertersForPair = new ConvertersForPair();
                this.converters.put(convertiblePair, convertersForPair);
            }
            return convertersForPair;
        }

        public void remove(Class<?> sourceType, Class<?> targetType) {
            this.converters.remove(new GenericConverter.ConvertiblePair(sourceType, targetType));
        }

        public GenericConverter find(TypeDescriptor sourceType, TypeDescriptor targetType) {
            List<TypeDescriptor> sourceCandidates = this.getTypeHierarchy(sourceType);
            List<TypeDescriptor> targetCandidates = this.getTypeHierarchy(targetType);
            for (TypeDescriptor sourceCandidate : sourceCandidates) {
                for (TypeDescriptor targetCandidate : targetCandidates) {
                    GenericConverter converter = this.getRegisteredConverter(sourceType, targetType, sourceCandidate, targetCandidate);
                    if (converter == null) continue;
                    return converter;
                }
            }
            return null;
        }

        private GenericConverter getRegisteredConverter(TypeDescriptor sourceType, TypeDescriptor targetType, TypeDescriptor sourceCandidate, TypeDescriptor targetCandidate) {
            GenericConverter converter;
            ConvertersForPair convertersForPair = this.converters.get(new GenericConverter.ConvertiblePair(sourceCandidate.getType(), targetCandidate.getType()));
            GenericConverter genericConverter = converter = convertersForPair == null ? null : convertersForPair.getConverter(sourceType, targetType);
            if (converter != null) {
                return converter;
            }
            for (GenericConverter globalConverter : this.globalConverters) {
                if (!((ConditionalConverter)((Object)globalConverter)).matches(sourceCandidate, targetCandidate)) continue;
                return globalConverter;
            }
            return null;
        }

        private List<TypeDescriptor> getTypeHierarchy(TypeDescriptor type) {
            if (type.isPrimitive()) {
                type = TypeDescriptor.valueOf(type.getObjectType());
            }
            LinkedHashSet<TypeDescriptor> typeHierarchy = new LinkedHashSet<TypeDescriptor>();
            this.collectTypeHierarchy(typeHierarchy, type);
            if (type.isArray()) {
                typeHierarchy.add(TypeDescriptor.valueOf(Object[].class));
            }
            typeHierarchy.add(TypeDescriptor.valueOf(Object.class));
            return new ArrayList<TypeDescriptor>(typeHierarchy);
        }

        private void collectTypeHierarchy(Set<TypeDescriptor> typeHierarchy, TypeDescriptor type) {
            if (type != null && !IGNORED_CLASSES.contains(type.getType()) && typeHierarchy.add(type)) {
                Class<?> superclass = type.getType().getSuperclass();
                if (type.isArray()) {
                    superclass = ClassUtils.resolvePrimitiveIfNecessary(superclass);
                }
                this.collectTypeHierarchy(typeHierarchy, this.createRelated(type, superclass));
                for (Class<?> implementsInterface : type.getType().getInterfaces()) {
                    this.collectTypeHierarchy(typeHierarchy, this.createRelated(type, implementsInterface));
                }
            }
        }

        private TypeDescriptor createRelated(TypeDescriptor type, Class<?> relatedType) {
            if (relatedType == null && type.isArray()) {
                relatedType = Array.newInstance(relatedType, 0).getClass();
            }
            if (!type.getType().equals(relatedType)) {
                return type.upcast(relatedType);
            }
            return null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConversionService converters = ").append("\n");
            for (String converterString : this.getConverterStrings()) {
                builder.append("\t");
                builder.append(converterString);
                builder.append("\n");
            }
            return builder.toString();
        }

        private List<String> getConverterStrings() {
            ArrayList<String> converterStrings = new ArrayList<String>();
            for (ConvertersForPair convertersForPair : this.converters.values()) {
                converterStrings.add(convertersForPair.toString());
            }
            Collections.sort(converterStrings);
            return converterStrings;
        }

        static {
            HashSet<Class> ignored = new HashSet<Class>();
            ignored.add(Object.class);
            ignored.add(Object[].class);
            IGNORED_CLASSES = Collections.unmodifiableSet(ignored);
        }
    }

    private static final class ConverterCacheKey {
        private final TypeDescriptor sourceType;
        private final TypeDescriptor targetType;

        public ConverterCacheKey(TypeDescriptor sourceType, TypeDescriptor targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConverterCacheKey)) {
                return false;
            }
            ConverterCacheKey otherKey = (ConverterCacheKey)other;
            return ObjectUtils.nullSafeEquals(this.sourceType, otherKey.sourceType) && ObjectUtils.nullSafeEquals(this.targetType, otherKey.targetType);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.sourceType) * 29 + ObjectUtils.nullSafeHashCode(this.targetType);
        }

        public String toString() {
            return "ConverterCacheKey [sourceType = " + this.sourceType + ", targetType = " + this.targetType + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterFactoryAdapter
    implements ConditionalGenericConverter {
        private final GenericConverter.ConvertiblePair typeInfo;
        private final ConverterFactory<Object, Object> converterFactory;

        public ConverterFactoryAdapter(GenericConverter.ConvertiblePair typeInfo, ConverterFactory<?, ?> converterFactory) {
            this.converterFactory = converterFactory;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            Converter<Object, ?> converter;
            boolean matches = true;
            if (this.converterFactory instanceof ConditionalConverter) {
                matches = ((ConditionalConverter)((Object)this.converterFactory)).matches(sourceType, targetType);
            }
            if (matches && (converter = this.converterFactory.getConverter(targetType.getType())) instanceof ConditionalConverter) {
                matches = ((ConditionalConverter)((Object)converter)).matches(sourceType, targetType);
            }
            return matches;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converterFactory.getConverter(targetType.getObjectType()).convert(source);
        }

        public String toString() {
            return this.typeInfo.getSourceType().getName() + " -> " + this.typeInfo.getTargetType().getName() + " : " + this.converterFactory.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterAdapter
    implements ConditionalGenericConverter {
        private final GenericConverter.ConvertiblePair typeInfo;
        private final Converter<Object, Object> converter;

        public ConverterAdapter(GenericConverter.ConvertiblePair typeInfo, Converter<?, ?> converter) {
            this.converter = converter;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!this.typeInfo.getTargetType().equals(targetType.getObjectType())) {
                return false;
            }
            if (this.converter instanceof ConditionalConverter) {
                return ((ConditionalConverter)((Object)this.converter)).matches(sourceType, targetType);
            }
            return true;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converter.convert(source);
        }

        public String toString() {
            return this.typeInfo.getSourceType().getName() + " -> " + this.typeInfo.getTargetType().getName() + " : " + this.converter.toString();
        }
    }
}

