/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.core.ControlFlow;
import org.springframework.util.Assert;

public abstract class ControlFlowFactory {
    public static ControlFlow createControlFlow() {
        return new Jdk14ControlFlow();
    }

    static class Jdk14ControlFlow
    implements ControlFlow {
        private StackTraceElement[] stack = new Throwable().getStackTrace();

        @Override
        public boolean under(Class clazz) {
            Assert.notNull(clazz, "Class must not be null");
            String className = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(className)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean under(Class clazz, String methodName) {
            Assert.notNull(clazz, "Class must not be null");
            Assert.notNull(methodName, "Method name must not be null");
            String className = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(className) || !this.stack[i].getMethodName().equals(methodName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean underToken(String token) {
            if (token == null) {
                return false;
            }
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            return stackTrace.indexOf(token) != -1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Jdk14ControlFlow: ");
            for (int i = 0; i < this.stack.length; ++i) {
                if (i > 0) {
                    sb.append("\n\t@");
                }
                sb.append(this.stack[i]);
            }
            return sb.toString();
        }
    }
}

