/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AnnotationUtils {
    static final String VALUE = "value";
    private static final Map<Class<?>, Boolean> annotatedInterfaceCache = new WeakHashMap();

    public static <T extends Annotation> T getAnnotation(Annotation ann, Class<T> annotationType) {
        if (annotationType.isInstance(ann)) {
            return (T)ann;
        }
        return ann.annotationType().getAnnotation(annotationType);
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement ae, Class<T> annotationType) {
        T ann = ae.getAnnotation(annotationType);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = ae.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(annotationType)) == null; ++i) {
            }
        }
        return ann;
    }

    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        return AnnotationUtils.getAnnotation((AnnotatedElement)resolvedMethod, annotationType);
    }

    public static <A extends Annotation> Set<A> getRepeatableAnnotation(Method method, Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        return AnnotationUtils.getRepeatableAnnotation((AnnotatedElement)resolvedMethod, containerAnnotationType, annotationType);
    }

    public static <A extends Annotation> Set<A> getRepeatableAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
        if (annotatedElement.getAnnotations().length == 0) {
            return Collections.emptySet();
        }
        return new AnnotationCollector<A>(containerAnnotationType, annotationType).getResult(annotatedElement);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> clazz = method.getDeclaringClass();
        if (annotation == null) {
            annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
        }
        while (annotation == null && (clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
            try {
                Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (annotation != null) continue;
            annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
        }
        return annotation;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class<?>[] ifcs) {
        A annotation = null;
        for (Class<?> iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (annotation != null) break;
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class<?>, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            for (Method ifcMethod : iface.getMethods()) {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = true;
                break;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass;
        Assert.notNull(clazz, "Class must not be null");
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            annotation = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            for (Annotation ann : clazz.getAnnotations()) {
                annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if ((superClass = clazz.getSuperclass()) == null || superClass.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass, annotationType);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return clazz;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            for (Annotation stereotype : clazz.getAnnotations()) {
                Class<?> declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, stereotype.annotationType());
                if (declaringClass == null) continue;
                return declaringClass;
            }
        }
        return AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static Class<?> findAnnotationDeclaringClassForTypes(List<Class<? extends Annotation>> annotationTypes, Class<?> clazz) {
        Assert.notEmpty(annotationTypes, "The list of annotation types must not be empty");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return clazz;
        }
        return AnnotationUtils.findAnnotationDeclaringClassForTypes(annotationTypes, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        boolean declaredLocally = false;
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            declaredLocally = true;
            break;
        }
        return declaredLocally;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(annotation, false, false);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation, boolean classValuesAsString) {
        return AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        Method[] methods;
        AnnotationAttributes attrs = new AnnotationAttributes();
        for (Method method : methods = annotation.annotationType().getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            try {
                int i;
                String[] value = method.invoke((Object)annotation, new Object[0]);
                if (classValuesAsString) {
                    if (value instanceof Class) {
                        value = ((Class)value).getName();
                    } else if (value instanceof Class[]) {
                        Class[] clazzArray = (Class[])value;
                        String[] newValue = new String[clazzArray.length];
                        for (i = 0; i < clazzArray.length; ++i) {
                            newValue[i] = clazzArray[i].getName();
                        }
                        value = newValue;
                    }
                }
                if (nestedAnnotationsAsMap && value instanceof Annotation) {
                    attrs.put(method.getName(), AnnotationUtils.getAnnotationAttributes((Annotation)value, classValuesAsString, nestedAnnotationsAsMap));
                    continue;
                }
                if (nestedAnnotationsAsMap && value instanceof Annotation[]) {
                    Annotation[] realAnnotations = (Annotation[])value;
                    AnnotationAttributes[] mappedAnnotations = new AnnotationAttributes[realAnnotations.length];
                    for (i = 0; i < realAnnotations.length; ++i) {
                        mappedAnnotations[i] = AnnotationUtils.getAnnotationAttributes(realAnnotations[i], classValuesAsString, nestedAnnotationsAsMap);
                    }
                    attrs.put(method.getName(), mappedAnnotations);
                    continue;
                }
                attrs.put(method.getName(), value);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not obtain annotation attribute values", ex);
            }
        }
        return attrs;
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation, String attributeName) {
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        try {
            Method method = annotationType.getDeclaredMethod(attributeName, new Class[0]);
            return method.getDefaultValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static class AnnotationCollector<A extends Annotation> {
        private final Class<? extends Annotation> containerAnnotationType;
        private final Class<A> annotationType;
        private final Set<AnnotatedElement> visited = new HashSet<AnnotatedElement>();
        private final Set<A> result = new LinkedHashSet<A>();

        public AnnotationCollector(Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
            this.containerAnnotationType = containerAnnotationType;
            this.annotationType = annotationType;
        }

        public Set<A> getResult(AnnotatedElement element) {
            this.process(element);
            return Collections.unmodifiableSet(this.result);
        }

        private void process(AnnotatedElement annotatedElement) {
            if (this.visited.add(annotatedElement)) {
                for (Annotation annotation : annotatedElement.getAnnotations()) {
                    if (ObjectUtils.nullSafeEquals(this.annotationType, annotation.annotationType())) {
                        this.result.add(annotation);
                        continue;
                    }
                    if (ObjectUtils.nullSafeEquals(this.containerAnnotationType, annotation.annotationType())) {
                        this.result.addAll(Arrays.asList(this.getValue(annotation)));
                        continue;
                    }
                    this.process(annotation.annotationType());
                }
            }
        }

        private A[] getValue(Annotation annotation) {
            try {
                Method method = annotation.annotationType().getDeclaredMethod(AnnotationUtils.VALUE, new Class[0]);
                return (Annotation[])method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to read value from repeating annotation container " + this.containerAnnotationType.getName(), ex);
            }
        }
    }
}

