/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;
import org.springframework.util.MultiValueMap;

final class AnnotationAttributesReadingVisitor
extends RecursiveAnnotationAttributesVisitor {
    private final String annotationType;
    private final MultiValueMap<String, AnnotationAttributes> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;

    public AnnotationAttributesReadingVisitor(String annotationType, MultiValueMap<String, AnnotationAttributes> attributesMap, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        super(annotationType, new AnnotationAttributes(), classLoader);
        this.annotationType = annotationType;
        this.attributesMap = attributesMap;
        this.metaAnnotationMap = metaAnnotationMap;
    }

    @Override
    public void doVisitEnd(Class<?> annotationClass) {
        super.doVisitEnd(annotationClass);
        List attributes = (List)this.attributesMap.get(this.annotationType);
        if (attributes == null) {
            this.attributesMap.add(this.annotationType, this.attributes);
        } else {
            attributes.add(0, this.attributes);
        }
        LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>();
        for (Annotation metaAnnotation : annotationClass.getAnnotations()) {
            this.recusivelyCollectMetaAnnotations(metaAnnotationTypeNames, metaAnnotation);
        }
        if (this.metaAnnotationMap != null) {
            this.metaAnnotationMap.put(annotationClass.getName(), metaAnnotationTypeNames);
        }
    }

    private void recusivelyCollectMetaAnnotations(Set<String> visited, Annotation annotation) {
        if (visited.add(annotation.annotationType().getName())) {
            this.attributesMap.add(annotation.annotationType().getName(), AnnotationUtils.getAnnotationAttributes(annotation, true, true));
            for (Annotation metaMetaAnnotation : annotation.annotationType().getAnnotations()) {
                this.recusivelyCollectMetaAnnotations(visited, metaMetaAnnotation);
            }
        }
    }
}

