/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.springframework.util.Assert;
import org.springframework.util.xml.StaxEventContentHandler;
import org.springframework.util.xml.StaxEventXMLReader;
import org.springframework.util.xml.StaxStreamContentHandler;
import org.springframework.util.xml.StaxStreamXMLReader;
import org.springframework.util.xml.XMLEventStreamReader;
import org.springframework.util.xml.XMLEventStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

public abstract class StaxUtils {
    public static Source createStaxSource(XMLStreamReader streamReader) {
        return new StAXSource(streamReader);
    }

    public static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
        return new StAXSource(eventReader);
    }

    public static boolean isStaxSource(Source source) {
        return source instanceof StAXSource;
    }

    public static Result createStaxResult(XMLStreamWriter streamWriter) {
        return new StAXResult(streamWriter);
    }

    public static Result createStaxResult(XMLEventWriter eventWriter) throws XMLStreamException {
        return new StAXResult(eventWriter);
    }

    public static boolean isStaxResult(Result result) {
        return result instanceof StAXResult;
    }

    public static XMLStreamReader getXMLStreamReader(Source source) {
        Assert.isInstanceOf(StAXSource.class, source);
        return ((StAXSource)source).getXMLStreamReader();
    }

    public static XMLEventReader getXMLEventReader(Source source) {
        Assert.isInstanceOf(StAXSource.class, source);
        return ((StAXSource)source).getXMLEventReader();
    }

    public static XMLStreamWriter getXMLStreamWriter(Result result) {
        Assert.isInstanceOf(StAXResult.class, result);
        return ((StAXResult)result).getXMLStreamWriter();
    }

    public static XMLEventWriter getXMLEventWriter(Result result) {
        Assert.isInstanceOf(StAXResult.class, result);
        return ((StAXResult)result).getXMLEventWriter();
    }

    public static ContentHandler createContentHandler(XMLStreamWriter streamWriter) {
        return new StaxStreamContentHandler(streamWriter);
    }

    public static ContentHandler createContentHandler(XMLEventWriter eventWriter) {
        return new StaxEventContentHandler(eventWriter);
    }

    public static XMLReader createXMLReader(XMLStreamReader streamReader) {
        return new StaxStreamXMLReader(streamReader);
    }

    public static XMLReader createXMLReader(XMLEventReader eventReader) {
        return new StaxEventXMLReader(eventReader);
    }

    public static XMLStreamReader createEventStreamReader(XMLEventReader eventReader) throws XMLStreamException {
        return new XMLEventStreamReader(eventReader);
    }

    public static XMLStreamWriter createEventStreamWriter(XMLEventWriter eventWriter) {
        return new XMLEventStreamWriter(eventWriter, XMLEventFactory.newFactory());
    }

    public static XMLStreamWriter createEventStreamWriter(XMLEventWriter eventWriter, XMLEventFactory eventFactory) {
        return new XMLEventStreamWriter(eventWriter, eventFactory);
    }
}

