/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class AnnotatedElementUtils {
    private static final Boolean CONTINUE = null;

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "annotationType must not be null");
        return AnnotatedElementUtils.getMetaAnnotationTypes(element, annotationType.getName());
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, String annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasText(annotationType, "annotationType must not be null or empty");
        final LinkedHashSet<String> types = new LinkedHashSet<String>();
        try {
            Annotation annotation = AnnotatedElementUtils.getAnnotation(element, annotationType);
            if (annotation != null) {
                AnnotatedElementUtils.searchWithGetSemantics(annotation.annotationType(), annotationType, new SimpleAnnotationProcessor<Object>(){

                    @Override
                    public Object process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                        types.add(annotation.annotationType().getName());
                        return CONTINUE;
                    }
                }, new HashSet<AnnotatedElement>(), 1);
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
        return types.isEmpty() ? null : types;
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, final String annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasText(annotationType, "annotationType must not be null or empty");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType().getName().equals(annotationType);
                return found && metaDepth > 0 ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static boolean isAnnotated(AnnotatedElement element, final String annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasText(annotationType, "annotationType must not be null or empty");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType().getName().equals(annotationType);
                return found ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationType) {
        return AnnotatedElementUtils.getAnnotationAttributes(element, annotationType, false, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, new MergedAnnotationAttributesProcessor(annotationType, classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static AnnotationAttributes findAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "annotationType must not be null");
        return AnnotatedElementUtils.findAnnotationAttributes(element, annotationType.getName());
    }

    public static AnnotationAttributes findAnnotationAttributes(AnnotatedElement element, String annotationType) {
        return AnnotatedElementUtils.findAnnotationAttributes(element, annotationType, false, false);
    }

    public static AnnotationAttributes findAnnotationAttributes(AnnotatedElement element, String annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, new MergedAnnotationAttributesProcessor(annotationType, classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationType) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(element, annotationType, false, false);
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, final String annotationType, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        final LinkedMultiValueMap<String, Object> attributesMap = new LinkedMultiValueMap<String, Object>();
        AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, new SimpleAnnotationProcessor<Void>(){

            @Override
            public Void process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType().getName().equals(annotationType);
                if (found) {
                    AnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap);
                    for (Map.Entry entry : annotationAttributes.entrySet()) {
                        attributesMap.add(entry.getKey(), entry.getValue());
                    }
                }
                return null;
            }
        });
        return attributesMap.isEmpty() ? null : attributesMap;
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, String annotationType, Processor<T> processor) {
        try {
            return AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, String annotationType, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasText(annotationType, "annotationType must not be null or empty");
        if (visited.add(element)) {
            try {
                List<Annotation> declaredAnnotations = Arrays.asList(element.getDeclaredAnnotations());
                T result = AnnotatedElementUtils.searchWithGetSemanticsInAnnotations(element, declaredAnnotations, annotationType, processor, visited, metaDepth);
                if (result != null) {
                    return result;
                }
                ArrayList<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
                for (Annotation annotation : element.getAnnotations()) {
                    if (declaredAnnotations.contains(annotation)) continue;
                    inheritedAnnotations.add(annotation);
                }
                result = AnnotatedElementUtils.searchWithGetSemanticsInAnnotations(element, inheritedAnnotations, annotationType, processor, visited, metaDepth);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(element, ex);
            }
        }
        return null;
    }

    private static <T> T searchWithGetSemanticsInAnnotations(AnnotatedElement annotatedElement, List<Annotation> annotations, String annotationType, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        T result;
        for (Annotation annotation : annotations) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || !annotation.annotationType().getName().equals(annotationType) && metaDepth <= 0 || (result = processor.process(annotatedElement, annotation, metaDepth)) == null) continue;
            return result;
        }
        for (Annotation annotation : annotations) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || (result = AnnotatedElementUtils.searchWithGetSemantics(annotation.annotationType(), annotationType, processor, visited, metaDepth + 1)) == null) continue;
            processor.postProcess(annotatedElement, annotation, result);
            return result;
        }
        return null;
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, String annotationType, Processor<T> processor) {
        return AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, true, true, true, true, processor);
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, String annotationType, boolean searchOnInterfaces, boolean searchOnSuperclasses, boolean searchOnMethodsInInterfaces, boolean searchOnMethodsInSuperclasses, Processor<T> processor) {
        try {
            return AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, String annotationType, boolean searchOnInterfaces, boolean searchOnSuperclasses, boolean searchOnMethodsInInterfaces, boolean searchOnMethodsInSuperclasses, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasText(annotationType, "annotationType must not be null or empty");
        if (visited.add(element)) {
            try {
                T result;
                Annotation[] annotations;
                for (Annotation annotation : annotations = searchOnSuperclasses ? element.getDeclaredAnnotations() : element.getAnnotations()) {
                    if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || !annotation.annotationType().getName().equals(annotationType) && metaDepth <= 0 || (result = processor.process(element, annotation, metaDepth)) == null) continue;
                    return result;
                }
                for (Annotation annotation : annotations) {
                    if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || (result = AnnotatedElementUtils.searchWithFindSemantics(annotation.annotationType(), annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth + 1)) == null) continue;
                    processor.postProcess(annotation.annotationType(), annotation, result);
                    return result;
                }
                if (element instanceof Method) {
                    Class<?>[] ifcs;
                    Method method = (Method)element;
                    Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
                    T result2 = AnnotatedElementUtils.searchWithFindSemantics(resolvedMethod, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth);
                    if (result2 != null) {
                        return result2;
                    }
                    if (searchOnMethodsInInterfaces && (result2 = AnnotatedElementUtils.searchOnInterfaces(method, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth, ifcs = method.getDeclaringClass().getInterfaces())) != null) {
                        return result2;
                    }
                    if (searchOnMethodsInSuperclasses) {
                        Class<?> clazz = method.getDeclaringClass();
                        while ((clazz = clazz.getSuperclass()) != null && Object.class != clazz) {
                            try {
                                Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                                Method resolvedEquivalentMethod = BridgeMethodResolver.findBridgedMethod(equivalentMethod);
                                result2 = AnnotatedElementUtils.searchWithFindSemantics(resolvedEquivalentMethod, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth);
                                if (result2 != null) {
                                    return result2;
                                }
                            }
                            catch (NoSuchMethodException equivalentMethod) {
                                // empty catch block
                            }
                            if (!searchOnMethodsInInterfaces || (result2 = AnnotatedElementUtils.searchOnInterfaces(method, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth, clazz.getInterfaces())) == null) continue;
                            return result2;
                        }
                    }
                }
                if (element instanceof Class) {
                    T result3;
                    Class superclass;
                    Class clazz = (Class)element;
                    if (searchOnInterfaces) {
                        for (Class<?> ifc : clazz.getInterfaces()) {
                            T result4 = AnnotatedElementUtils.searchWithFindSemantics(ifc, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth);
                            if (result4 == null) continue;
                            return result4;
                        }
                    }
                    if (searchOnSuperclasses && (superclass = clazz.getSuperclass()) != null && Object.class != superclass && (result3 = AnnotatedElementUtils.searchWithFindSemantics(superclass, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth)) != null) {
                        return result3;
                    }
                }
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(element, ex);
            }
        }
        return null;
    }

    private static <T> T searchOnInterfaces(Method method, String annotationType, boolean searchOnInterfaces, boolean searchOnSuperclasses, boolean searchOnMethodsInInterfaces, boolean searchOnMethodsInSuperclasses, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth, Class<?>[] ifcs) {
        for (Class<?> iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                T result = AnnotatedElementUtils.searchWithFindSemantics(equivalentMethod, annotationType, searchOnInterfaces, searchOnSuperclasses, searchOnMethodsInInterfaces, searchOnMethodsInSuperclasses, processor, visited, metaDepth);
                if (result == null) continue;
                return result;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Annotation getAnnotation(AnnotatedElement element, String annotationType) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    private static class MergedAnnotationAttributesProcessor
    implements Processor<AnnotationAttributes> {
        private final String annotationTypeName;
        private final boolean classValuesAsString;
        private final boolean nestedAnnotationsAsMap;

        MergedAnnotationAttributesProcessor(String annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
            this.annotationTypeName = annotationType;
            this.classValuesAsString = classValuesAsString;
            this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
        }

        @Override
        public AnnotationAttributes process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
            boolean found = annotation.annotationType().getName().equals(this.annotationTypeName);
            return found ? AnnotationUtils.getAnnotationAttributes(annotatedElement, annotation, this.classValuesAsString, this.nestedAnnotationsAsMap, true) : null;
        }

        @Override
        public void postProcess(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes) {
            annotation = AnnotationUtils.synthesizeAnnotation(annotation, element);
            Class<? extends Annotation> targetAnnotationType = attributes.annotationType();
            for (Method attributeMethod : AnnotationUtils.getAttributeMethods(annotation.annotationType())) {
                String attributeName = attributeMethod.getName();
                String aliasedAttributeName = AnnotationUtils.getAliasedAttributeName(attributeMethod, targetAnnotationType);
                if (StringUtils.hasText(aliasedAttributeName) && attributes.containsKey(aliasedAttributeName)) {
                    this.overrideAttribute(element, annotation, attributes, attributeName, aliasedAttributeName);
                    continue;
                }
                if ("value".equals(attributeName) || !attributes.containsKey(attributeName)) continue;
                this.overrideAttribute(element, annotation, attributes, attributeName, attributeName);
            }
        }

        private void overrideAttribute(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes, String sourceAttributeName, String targetAttributeName) {
            Object value = AnnotationUtils.getValue(annotation, sourceAttributeName);
            Object adaptedValue = AnnotationUtils.adaptValue(element, value, this.classValuesAsString, this.nestedAnnotationsAsMap);
            attributes.put(targetAttributeName, adaptedValue);
        }
    }

    private static abstract class SimpleAnnotationProcessor<T>
    implements Processor<T> {
        private SimpleAnnotationProcessor() {
        }

        @Override
        public final void postProcess(AnnotatedElement annotatedElement, Annotation annotation, T result) {
        }
    }

    private static interface Processor<T> {
        public T process(AnnotatedElement var1, Annotation var2, int var3);

        public void postProcess(AnnotatedElement var1, Annotation var2, T var3);
    }
}

