/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    private final Class<? extends Annotation> annotationType;
    private final String displayName;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = "unknown";
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        this.displayName = this.annotationType() != null ? annotationType.getName() : "unknown";
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
        this.annotationType = null;
        this.displayName = "unknown";
    }

    public AnnotationAttributes(Map<String, Object> map) {
        super(map);
        this.annotationType = null;
        this.displayName = "unknown";
    }

    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String attributeName) {
        return this.doGet(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.doGet(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.doGet(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.doGet(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.doGet(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.doGet(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.doGet(attributeName, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes.class);
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes[].class);
    }

    private <T> T doGet(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "attributeName must not be null or empty");
        Object value = this.get(attributeName);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.displayName));
        }
        if (!expectedType.isInstance(value)) {
            if (expectedType.isArray() && expectedType.getComponentType().isInstance(value)) {
                Object arrayValue = Array.newInstance(expectedType.getComponentType(), 1);
                Array.set(arrayValue, 0, value);
                value = arrayValue;
            } else {
                throw new IllegalArgumentException(String.format("Attribute '%s' is of type [%s], but [%s] was expected in attributes for annotation [%s]", attributeName, value.getClass().getSimpleName(), expectedType.getSimpleName(), this.displayName));
            }
        }
        return (T)value;
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        Object obj = this.get(key);
        if (obj == null) {
            obj = this.put(key, value);
        }
        return obj;
    }

    @Override
    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry.getValue()));
            sb.append(entries.hasNext() ? ", " : "");
        }
        sb.append("}");
        return sb.toString();
    }

    private String valueToString(Object value) {
        if (value == this) {
            return "(this Map)";
        }
        if (value instanceof Object[]) {
            return "[" + StringUtils.arrayToDelimitedString((Object[])value, ", ") + "]";
        }
        return String.valueOf(value);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map;
        }
        return new AnnotationAttributes(map);
    }
}

