/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class SynthesizedAnnotationInvocationHandler
implements InvocationHandler {
    private final AnnotatedElement annotatedElement;
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationType;
    private final Map<String, String> aliasMap;
    private final Map<String, Object> computedValueCache;

    SynthesizedAnnotationInvocationHandler(Annotation annotation, AnnotatedElement annotatedElement, Map<String, String> aliasMap) {
        this.annotatedElement = annotatedElement;
        this.annotation = annotation;
        this.annotationType = annotation.annotationType();
        this.aliasMap = aliasMap;
        this.computedValueCache = new ConcurrentHashMap<String, Object>(aliasMap.size());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (ReflectionUtils.isEqualsMethod(method)) {
            return this.equals(proxy, args[0]);
        }
        if (ReflectionUtils.isHashCodeMethod(method)) {
            return this.hashCode(proxy);
        }
        if (ReflectionUtils.isToStringMethod(method)) {
            return this.toString(proxy);
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        boolean nestedAnnotation = Annotation[].class.isAssignableFrom(returnType) || Annotation.class.isAssignableFrom(returnType);
        String aliasedAttributeName = this.aliasMap.get(methodName);
        boolean aliasPresent = aliasedAttributeName != null;
        ReflectionUtils.makeAccessible(method);
        if (!aliasPresent && !nestedAnnotation) {
            return ReflectionUtils.invokeMethod(method, this.annotation, args);
        }
        Object cachedValue = this.computedValueCache.get(methodName);
        if (cachedValue != null) {
            return cachedValue;
        }
        Object value = ReflectionUtils.invokeMethod(method, this.annotation, args);
        if (aliasPresent) {
            Method aliasedMethod = null;
            try {
                aliasedMethod = this.annotationType.getDeclaredMethod(aliasedAttributeName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String msg = String.format("In annotation [%s], attribute [%s] is declared as an @AliasFor [%s], but attribute [%s] does not exist.", this.annotationType.getName(), methodName, aliasedAttributeName, aliasedAttributeName);
                throw new AnnotationConfigurationException(msg);
            }
            ReflectionUtils.makeAccessible(aliasedMethod);
            Object aliasedValue = ReflectionUtils.invokeMethod(aliasedMethod, this.annotation);
            Object defaultValue = AnnotationUtils.getDefaultValue(this.annotation, methodName);
            if (!(SynthesizedAnnotationInvocationHandler.nullSafeEquals(value, aliasedValue) || SynthesizedAnnotationInvocationHandler.nullSafeEquals(value, defaultValue) || SynthesizedAnnotationInvocationHandler.nullSafeEquals(aliasedValue, defaultValue))) {
                String elementName = this.annotatedElement == null ? "unknown element" : this.annotatedElement.toString();
                String msg = String.format("In annotation [%s] declared on [%s], attribute [%s] and its alias [%s] are declared with values of [%s] and [%s], but only one declaration is permitted.", this.annotationType.getName(), elementName, methodName, aliasedAttributeName, SynthesizedAnnotationInvocationHandler.nullSafeToString(value), SynthesizedAnnotationInvocationHandler.nullSafeToString(aliasedValue));
                throw new AnnotationConfigurationException(msg);
            }
            if (SynthesizedAnnotationInvocationHandler.nullSafeEquals(value, defaultValue)) {
                value = aliasedValue;
            }
        }
        if (value instanceof Annotation) {
            value = AnnotationUtils.synthesizeAnnotation((Annotation)value, this.annotatedElement);
        } else if (value instanceof Annotation[]) {
            Annotation[] annotations = (Annotation[])value;
            for (int i = 0; i < annotations.length; ++i) {
                annotations[i] = AnnotationUtils.synthesizeAnnotation(annotations[i], this.annotatedElement);
            }
        }
        this.computedValueCache.put(methodName, value);
        return value;
    }

    private boolean equals(Object proxy, Object other) {
        if (this == other) {
            return true;
        }
        if (!this.annotationType.isInstance(other)) {
            return false;
        }
        for (Method attributeMethod : AnnotationUtils.getAttributeMethods(this.annotationType)) {
            Object otherValue;
            Object thisValue = ReflectionUtils.invokeMethod(attributeMethod, proxy);
            if (SynthesizedAnnotationInvocationHandler.nullSafeEquals(thisValue, otherValue = ReflectionUtils.invokeMethod(attributeMethod, other))) continue;
            return false;
        }
        return true;
    }

    private int hashCode(Object proxy) {
        int result = 0;
        for (Method attributeMethod : AnnotationUtils.getAttributeMethods(this.annotationType)) {
            Object value = ReflectionUtils.invokeMethod(attributeMethod, proxy);
            int hashCode = value.getClass().isArray() ? this.hashCodeForArray(value) : value.hashCode();
            result += 127 * attributeMethod.getName().hashCode() ^ hashCode;
        }
        return result;
    }

    private int hashCodeForArray(Object array) {
        if (array instanceof boolean[]) {
            return Arrays.hashCode((boolean[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.hashCode((byte[])array);
        }
        if (array instanceof char[]) {
            return Arrays.hashCode((char[])array);
        }
        if (array instanceof double[]) {
            return Arrays.hashCode((double[])array);
        }
        if (array instanceof float[]) {
            return Arrays.hashCode((float[])array);
        }
        if (array instanceof int[]) {
            return Arrays.hashCode((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.hashCode((long[])array);
        }
        if (array instanceof short[]) {
            return Arrays.hashCode((short[])array);
        }
        return Arrays.hashCode((Object[])array);
    }

    private String toString(Object proxy) {
        StringBuilder sb = new StringBuilder("@").append(this.annotationType.getName()).append("(");
        Iterator<Method> iterator = AnnotationUtils.getAttributeMethods(this.annotationType).iterator();
        while (iterator.hasNext()) {
            Method attributeMethod = iterator.next();
            sb.append(attributeMethod.getName());
            sb.append('=');
            sb.append(this.valueToString(ReflectionUtils.invokeMethod(attributeMethod, proxy)));
            sb.append(iterator.hasNext() ? ", " : "");
        }
        return sb.append(")").toString();
    }

    private String valueToString(Object value) {
        if (value instanceof Object[]) {
            return "[" + StringUtils.arrayToDelimitedString((Object[])value, ", ") + "]";
        }
        return String.valueOf(value);
    }

    private static boolean nullSafeEquals(Object o1, Object o2) {
        return ObjectUtils.nullSafeEquals(o1, o2);
    }

    private static String nullSafeToString(Object obj) {
        return ObjectUtils.nullSafeToString(obj);
    }
}

