/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis;

import org.springframework.objenesis.Objenesis;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.strategy.InstantiatorStrategy;
import org.springframework.objenesis.strategy.StdInstantiatorStrategy;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SpringObjenesis
implements Objenesis {
    private final InstantiatorStrategy strategy = new StdInstantiatorStrategy();
    private final ConcurrentReferenceHashMap<Class<?>, ObjectInstantiator<?>> cache = new ConcurrentReferenceHashMap();

    @Override
    public <T> T newInstance(Class<T> clazz) {
        return this.getInstantiatorOf(clazz).newInstance();
    }

    @Override
    public <T> ObjectInstantiator<T> getInstantiatorOf(Class<T> clazz) {
        ObjectInstantiator<T> newInstantiator;
        ObjectInstantiator<Object> instantiator = this.cache.get(clazz);
        if (instantiator == null && (instantiator = this.cache.putIfAbsent(clazz, newInstantiator = this.strategy.newInstantiatorOf(clazz))) == null) {
            instantiator = newInstantiator;
        }
        return instantiator;
    }
}

