/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.DefaultAnnotationAttributeExtractor;
import org.springframework.core.annotation.MapAnnotationAttributeExtractor;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.core.annotation.SynthesizedAnnotationInvocationHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationUtils {
    public static final String VALUE = "value";
    private static final Object DEFAULT_VALUE_PLACEHOLDER = new String("<SPRING DEFAULT VALUE PLACEHOLDER>");
    private static final Map<AnnotationCacheKey, Annotation> findAnnotationCache = new ConcurrentReferenceHashMap<AnnotationCacheKey, Annotation>(256);
    private static final Map<Class<?>, Boolean> annotatedInterfaceCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<? extends Annotation>, Boolean> synthesizableCache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, Boolean>(256);
    private static final Map<Class<? extends Annotation>, Map<String, String>> attributeAliasesCache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, Map<String, String>>(256);
    private static final Map<Class<? extends Annotation>, List<Method>> attributeMethodsCache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, List<Method>>(256);
    private static transient Log logger;

    public static <A extends Annotation> A getAnnotation(Annotation ann, Class<A> annotationType) {
        if (annotationType.isInstance(ann)) {
            return (A)AnnotationUtils.synthesizeAnnotation(ann);
        }
        Class<? extends Annotation> annotatedElement = ann.annotationType();
        try {
            return AnnotationUtils.synthesizeAnnotation(annotatedElement.getAnnotation(annotationType), annotatedElement);
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, ex);
            return null;
        }
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        try {
            A annotation = annotatedElement.getAnnotation(annotationType);
            if (annotation == null) {
                Annotation metaAnn;
                Annotation[] annotationArray = annotatedElement.getAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n && (annotation = (metaAnn = annotationArray[i]).annotationType().getAnnotation(annotationType)) == null; ++i) {
                }
            }
            return AnnotationUtils.synthesizeAnnotation(annotation, annotatedElement);
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, ex);
            return null;
        }
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        return AnnotationUtils.getAnnotation((AnnotatedElement)resolvedMethod, annotationType);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotatedElement) {
        try {
            return AnnotationUtils.synthesizeAnnotationArray(annotatedElement.getAnnotations(), annotatedElement);
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, ex);
            return null;
        }
    }

    public static Annotation[] getAnnotations(Method method) {
        try {
            return AnnotationUtils.synthesizeAnnotationArray(BridgeMethodResolver.findBridgedMethod(method).getAnnotations(), method);
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(method, ex);
            return null;
        }
    }

    @Deprecated
    public static <A extends Annotation> Set<A> getRepeatableAnnotation(Method method, Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
        return AnnotationUtils.getRepeatableAnnotations(method, annotationType, containerAnnotationType);
    }

    @Deprecated
    public static <A extends Annotation> Set<A> getRepeatableAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> containerAnnotationType, Class<A> annotationType) {
        return AnnotationUtils.getRepeatableAnnotations(annotatedElement, annotationType, containerAnnotationType);
    }

    public static <A extends Annotation> Set<A> getRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return AnnotationUtils.getRepeatableAnnotations(annotatedElement, annotationType, null);
    }

    public static <A extends Annotation> Set<A> getRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> annotationType, Class<? extends Annotation> containerAnnotationType) {
        Class superclass;
        Set<A> annotations = AnnotationUtils.getDeclaredRepeatableAnnotations(annotatedElement, annotationType, containerAnnotationType);
        if (!annotations.isEmpty()) {
            return annotations;
        }
        if (annotatedElement instanceof Class && (superclass = ((Class)annotatedElement).getSuperclass()) != null && Object.class != superclass) {
            return AnnotationUtils.getRepeatableAnnotations(superclass, annotationType, containerAnnotationType);
        }
        return AnnotationUtils.getRepeatableAnnotations(annotatedElement, annotationType, containerAnnotationType, false);
    }

    public static <A extends Annotation> Set<A> getDeclaredRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return AnnotationUtils.getDeclaredRepeatableAnnotations(annotatedElement, annotationType, null);
    }

    public static <A extends Annotation> Set<A> getDeclaredRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> annotationType, Class<? extends Annotation> containerAnnotationType) {
        return AnnotationUtils.getRepeatableAnnotations(annotatedElement, annotationType, containerAnnotationType, true);
    }

    private static <A extends Annotation> Set<A> getRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> annotationType, Class<? extends Annotation> containerAnnotationType, boolean declaredMode) {
        Assert.notNull(annotatedElement, "annotatedElement must not be null");
        Assert.notNull(annotationType, "annotationType must not be null");
        try {
            if (annotatedElement instanceof Method) {
                annotatedElement = BridgeMethodResolver.findBridgedMethod((Method)annotatedElement);
            }
            return new AnnotationCollector<A>(annotationType, containerAnnotationType, declaredMode).getResult(annotatedElement);
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, ex);
            return Collections.emptySet();
        }
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return AnnotationUtils.synthesizeAnnotation(AnnotationUtils.findAnnotation(annotatedElement, annotationType, new HashSet<Annotation>()), annotatedElement);
    }

    private static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType, Set<Annotation> visited) {
        Assert.notNull(annotatedElement, "AnnotatedElement must not be null");
        try {
            Annotation[] anns;
            for (Annotation ann : anns = annotatedElement.getDeclaredAnnotations()) {
                if (!ann.annotationType().equals(annotationType)) continue;
                return (A)ann;
            }
            for (Annotation ann : anns) {
                A annotation;
                if (AnnotationUtils.isInJavaLangAnnotationPackage(ann) || !visited.add(ann) || (annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType, visited)) == null) continue;
                return annotation;
            }
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, ex);
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        AnnotationCacheKey cacheKey = new AnnotationCacheKey(method, annotationType);
        Annotation result = findAnnotationCache.get(cacheKey);
        if (result == null) {
            Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
            result = AnnotationUtils.findAnnotation((AnnotatedElement)resolvedMethod, annotationType);
            if (result == null) {
                result = AnnotationUtils.searchOnInterfaces(method, annotationType, method.getDeclaringClass().getInterfaces());
            }
            Class<?> clazz = method.getDeclaringClass();
            while (result == null && (clazz = clazz.getSuperclass()) != null && Object.class != clazz) {
                try {
                    Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    Method resolvedEquivalentMethod = BridgeMethodResolver.findBridgedMethod(equivalentMethod);
                    result = AnnotationUtils.findAnnotation((AnnotatedElement)resolvedEquivalentMethod, annotationType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (result != null) continue;
                result = AnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
            }
            if (result != null) {
                findAnnotationCache.put(cacheKey, result);
            }
        }
        return (A)AnnotationUtils.synthesizeAnnotation(result, method);
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class<?> ... ifcs) {
        A annotation = null;
        for (Class<?> iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (annotation != null) break;
        }
        return annotation;
    }

    static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Boolean found = annotatedInterfaceCache.get(iface);
        if (found != null) {
            return found;
        }
        found = Boolean.FALSE;
        for (Method ifcMethod : iface.getMethods()) {
            try {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = Boolean.TRUE;
                break;
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(ifcMethod, ex);
            }
        }
        annotatedInterfaceCache.put(iface, found);
        return found;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        AnnotationCacheKey cacheKey = new AnnotationCacheKey(clazz, annotationType);
        Annotation result = findAnnotationCache.get(cacheKey);
        if (result == null && (result = AnnotationUtils.findAnnotation(clazz, annotationType, new HashSet<Annotation>())) != null) {
            findAnnotationCache.put(cacheKey, result);
        }
        return (A)AnnotationUtils.synthesizeAnnotation(result, clazz);
    }

    private static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType, Set<Annotation> visited) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            Annotation[] anns;
            for (Annotation ann : anns = clazz.getDeclaredAnnotations()) {
                if (!ann.annotationType().equals(annotationType)) continue;
                return (A)ann;
            }
            Annotation[] annotationArray = anns;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                A annotation;
                Annotation ann;
                ann = annotationArray[i];
                if (AnnotationUtils.isInJavaLangAnnotationPackage(ann) || !visited.add(ann) || (annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType, visited)) == null) continue;
                return annotation;
            }
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(clazz, ex);
            return null;
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            A annotation = AnnotationUtils.findAnnotation(ifc, annotationType, visited);
            if (annotation == null) continue;
            return annotation;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || Object.class == superclass) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superclass, annotationType, visited);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || Object.class == clazz) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return clazz;
        }
        return AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static Class<?> findAnnotationDeclaringClassForTypes(List<Class<? extends Annotation>> annotationTypes, Class<?> clazz) {
        Assert.notEmpty(annotationTypes, "The list of annotation types must not be empty");
        if (clazz == null || Object.class == clazz) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return clazz;
        }
        return AnnotationUtils.findAnnotationDeclaringClassForTypes(annotationTypes, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        try {
            for (Annotation ann : clazz.getDeclaredAnnotations()) {
                if (!ann.annotationType().equals(annotationType)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            AnnotationUtils.handleIntrospectionFailure(clazz, ex);
        }
        return false;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static boolean isInJavaLangAnnotationPackage(Annotation annotation) {
        Assert.notNull(annotation, "Annotation must not be null");
        return AnnotationUtils.isInJavaLangAnnotationPackage(annotation.annotationType().getName());
    }

    public static boolean isInJavaLangAnnotationPackage(String annotationType) {
        Assert.hasText(annotationType, "annotationType must not be null or empty");
        return annotationType.startsWith("java.lang.annotation");
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(null, annotation);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation, boolean classValuesAsString) {
        return AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        return AnnotationUtils.getAnnotationAttributes(null, annotation, classValuesAsString, nestedAnnotationsAsMap);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotation, false, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Annotation annotation, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotation, classValuesAsString, nestedAnnotationsAsMap, false);
    }

    static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Annotation annotation, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean mergeMode) {
        if (!mergeMode) {
            annotation = AnnotationUtils.synthesizeAnnotation(annotation, annotatedElement);
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        AnnotationAttributes attrs = new AnnotationAttributes(annotationType);
        for (Method method : AnnotationUtils.getAttributeMethods(annotationType)) {
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                Object defaultValue = method.getDefaultValue();
                if (mergeMode && defaultValue != null && ObjectUtils.nullSafeEquals(value, defaultValue)) {
                    value = DEFAULT_VALUE_PLACEHOLDER;
                }
                attrs.put(method.getName(), AnnotationUtils.adaptValue(annotatedElement, value, classValuesAsString, nestedAnnotationsAsMap));
            }
            catch (Exception ex) {
                if (ex instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                    AnnotationUtils.rethrowAnnotationConfigurationException(targetException);
                }
                throw new IllegalStateException("Could not obtain annotation attribute value for " + method, ex);
            }
        }
        return attrs;
    }

    static Object adaptValue(AnnotatedElement annotatedElement, Object value, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        if (classValuesAsString) {
            if (value instanceof Class) {
                return ((Class)value).getName();
            }
            if (value instanceof Class[]) {
                Class[] clazzArray = (Class[])value;
                String[] classNames = new String[clazzArray.length];
                for (int i = 0; i < clazzArray.length; ++i) {
                    classNames[i] = clazzArray[i].getName();
                }
                return classNames;
            }
        }
        if (value instanceof Annotation) {
            Annotation annotation = (Annotation)value;
            if (nestedAnnotationsAsMap) {
                return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotation, classValuesAsString, true);
            }
            return AnnotationUtils.synthesizeAnnotation(annotation, annotatedElement);
        }
        if (value instanceof Annotation[]) {
            Annotation[] annotations = (Annotation[])value;
            if (nestedAnnotationsAsMap) {
                AnnotationAttributes[] mappedAnnotations = new AnnotationAttributes[annotations.length];
                for (int i = 0; i < annotations.length; ++i) {
                    mappedAnnotations[i] = AnnotationUtils.getAnnotationAttributes(annotatedElement, annotations[i], classValuesAsString, true);
                }
                return mappedAnnotations;
            }
            return AnnotationUtils.synthesizeAnnotationArray(annotations, annotatedElement);
        }
        return value;
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        if (annotation == null || !StringUtils.hasText(attributeName)) {
            return null;
        }
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            ReflectionUtils.makeAccessible(method);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation, String attributeName) {
        if (annotation == null) {
            return null;
        }
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        if (annotationType == null || !StringUtils.hasText(attributeName)) {
            return null;
        }
        try {
            return annotationType.getDeclaredMethod(attributeName, new Class[0]).getDefaultValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static <A extends Annotation> A synthesizeAnnotation(A annotation) {
        return AnnotationUtils.synthesizeAnnotation(annotation, null);
    }

    public static <A extends Annotation> A synthesizeAnnotation(A annotation, AnnotatedElement annotatedElement) {
        if (annotation == null) {
            return null;
        }
        if (annotation instanceof SynthesizedAnnotation) {
            return annotation;
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (!AnnotationUtils.isSynthesizable(annotationType)) {
            return annotation;
        }
        DefaultAnnotationAttributeExtractor attributeExtractor = new DefaultAnnotationAttributeExtractor(annotation, annotatedElement);
        SynthesizedAnnotationInvocationHandler handler = new SynthesizedAnnotationInvocationHandler(attributeExtractor);
        Annotation synthesizedAnnotation = (Annotation)Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), new Class[]{annotationType, SynthesizedAnnotation.class}, (InvocationHandler)handler);
        return (A)synthesizedAnnotation;
    }

    public static <A extends Annotation> A synthesizeAnnotation(Map<String, Object> attributes, Class<A> annotationType, AnnotatedElement annotatedElement) {
        Assert.notNull(annotationType, "annotationType must not be null");
        if (attributes == null) {
            return null;
        }
        MapAnnotationAttributeExtractor attributeExtractor = new MapAnnotationAttributeExtractor(attributes, annotationType, annotatedElement);
        SynthesizedAnnotationInvocationHandler handler = new SynthesizedAnnotationInvocationHandler(attributeExtractor);
        Annotation synthesizedAnnotation = (Annotation)Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), new Class[]{annotationType, SynthesizedAnnotation.class}, (InvocationHandler)handler);
        return (A)synthesizedAnnotation;
    }

    public static <A extends Annotation> A synthesizeAnnotation(Class<A> annotationType) {
        return AnnotationUtils.synthesizeAnnotation(Collections.<String, Object>emptyMap(), annotationType, null);
    }

    public static Annotation[] synthesizeAnnotationArray(Annotation[] annotations, AnnotatedElement annotatedElement) {
        if (annotations == null) {
            return null;
        }
        Annotation[] synthesized = (Annotation[])Array.newInstance(annotations.getClass().getComponentType(), annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            synthesized[i] = AnnotationUtils.synthesizeAnnotation(annotations[i], annotatedElement);
        }
        return synthesized;
    }

    static Map<String, String> getAttributeAliasMap(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            return Collections.emptyMap();
        }
        Map<String, String> map = attributeAliasesCache.get(annotationType);
        if (map != null) {
            return map;
        }
        map = new HashMap<String, String>();
        for (Method attribute : AnnotationUtils.getAttributeMethods(annotationType)) {
            String attributeName = attribute.getName();
            String aliasedAttributeName = AnnotationUtils.getAliasedAttributeName(attribute);
            if (aliasedAttributeName == null) continue;
            map.put(attributeName, aliasedAttributeName);
        }
        attributeAliasesCache.put(annotationType, map);
        return map;
    }

    private static boolean isSynthesizable(Class<? extends Annotation> annotationType) {
        Boolean synthesizable = synthesizableCache.get(annotationType);
        if (synthesizable != null) {
            return synthesizable;
        }
        synthesizable = Boolean.FALSE;
        for (Method attribute : AnnotationUtils.getAttributeMethods(annotationType)) {
            Class<?> nestedAnnotationType;
            if (AnnotationUtils.getAliasedAttributeName(attribute) != null) {
                synthesizable = Boolean.TRUE;
                break;
            }
            Class<?> returnType = attribute.getReturnType();
            if (Annotation[].class.isAssignableFrom(returnType)) {
                nestedAnnotationType = returnType.getComponentType();
                if (!AnnotationUtils.isSynthesizable(nestedAnnotationType)) continue;
                synthesizable = Boolean.TRUE;
                break;
            }
            if (!Annotation.class.isAssignableFrom(returnType) || !AnnotationUtils.isSynthesizable(nestedAnnotationType = returnType)) continue;
            synthesizable = Boolean.TRUE;
            break;
        }
        synthesizableCache.put(annotationType, synthesizable);
        return synthesizable;
    }

    static String getAliasedAttributeName(Method attribute) {
        return AnnotationUtils.getAliasedAttributeName(attribute, null);
    }

    static String getAliasedAttributeName(Method attribute, Class<? extends Annotation> targetAnnotationType) {
        Class<?> aliasedReturnType;
        Class<?> returnType;
        Method aliasedAttribute;
        boolean sameTargetDeclared;
        Class<?> declaringClass = attribute.getDeclaringClass();
        Assert.isTrue(declaringClass.isAnnotation(), "attribute method must be from an annotation");
        Assert.isTrue(!Annotation.class.equals(targetAnnotationType), "targetAnnotationType must not be java.lang.annotation.Annotation");
        AliasFor aliasFor = attribute.getAnnotation(AliasFor.class);
        if (aliasFor == null) {
            return null;
        }
        Class<?> sourceAnnotationType = declaringClass;
        Class<Annotation> aliasedAnnotationType = aliasFor.annotation();
        boolean searchWithinSameAnnotation = targetAnnotationType == null;
        boolean bl = sameTargetDeclared = sourceAnnotationType.equals(aliasedAnnotationType) || Annotation.class.equals(aliasedAnnotationType);
        if (searchWithinSameAnnotation && !sameTargetDeclared) {
            return null;
        }
        String attributeName = attribute.getName();
        String aliasedAttributeName = aliasFor.attribute();
        if (!StringUtils.hasText(aliasedAttributeName)) {
            String msg = String.format("@AliasFor declaration on attribute [%s] in annotation [%s] is missing required 'attribute' value.", attributeName, sourceAnnotationType.getName());
            throw new AnnotationConfigurationException(msg);
        }
        if (sameTargetDeclared) {
            aliasedAnnotationType = sourceAnnotationType;
        }
        try {
            aliasedAttribute = aliasedAnnotationType.getDeclaredMethod(aliasedAttributeName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            String msg = String.format("Attribute [%s] in annotation [%s] is declared as an @AliasFor nonexistent attribute [%s] in annotation [%s].", attributeName, sourceAnnotationType.getName(), aliasedAttributeName, aliasedAnnotationType.getName());
            throw new AnnotationConfigurationException(msg, ex);
        }
        if (sameTargetDeclared) {
            AliasFor mirrorAliasFor = aliasedAttribute.getAnnotation(AliasFor.class);
            if (mirrorAliasFor == null) {
                String msg = String.format("Attribute [%s] in annotation [%s] must be declared as an @AliasFor [%s].", aliasedAttributeName, sourceAnnotationType.getName(), attributeName);
                throw new AnnotationConfigurationException(msg);
            }
            String mirrorAliasedAttributeName = mirrorAliasFor.attribute();
            if (!attributeName.equals(mirrorAliasedAttributeName)) {
                String msg = String.format("Attribute [%s] in annotation [%s] must be declared as an @AliasFor [%s], not [%s].", aliasedAttributeName, sourceAnnotationType.getName(), attributeName, mirrorAliasedAttributeName);
                throw new AnnotationConfigurationException(msg);
            }
        }
        if (!(returnType = attribute.getReturnType()).equals(aliasedReturnType = aliasedAttribute.getReturnType())) {
            String msg = String.format("Misconfigured aliases: attribute [%s] in annotation [%s] and attribute [%s] in annotation [%s] must declare the same return type.", attributeName, sourceAnnotationType.getName(), aliasedAttributeName, aliasedAnnotationType.getName());
            throw new AnnotationConfigurationException(msg);
        }
        if (sameTargetDeclared) {
            Object defaultValue = attribute.getDefaultValue();
            Object aliasedDefaultValue = aliasedAttribute.getDefaultValue();
            if (defaultValue == null || aliasedDefaultValue == null) {
                String msg = String.format("Misconfigured aliases: attribute [%s] in annotation [%s] and attribute [%s] in annotation [%s] must declare default values.", attributeName, sourceAnnotationType.getName(), aliasedAttributeName, aliasedAnnotationType.getName());
                throw new AnnotationConfigurationException(msg);
            }
            if (!ObjectUtils.nullSafeEquals(defaultValue, aliasedDefaultValue)) {
                String msg = String.format("Misconfigured aliases: attribute [%s] in annotation [%s] and attribute [%s] in annotation [%s] must declare the same default value.", attributeName, sourceAnnotationType.getName(), aliasedAttributeName, aliasedAnnotationType.getName());
                throw new AnnotationConfigurationException(msg);
            }
        }
        return aliasedAttributeName;
    }

    static List<Method> getAttributeMethods(Class<? extends Annotation> annotationType) {
        List<Method> methods = attributeMethodsCache.get(annotationType);
        if (methods != null) {
            return methods;
        }
        methods = new ArrayList<Method>();
        for (Method method : annotationType.getDeclaredMethods()) {
            if (!AnnotationUtils.isAttributeMethod(method)) continue;
            ReflectionUtils.makeAccessible(method);
            methods.add(method);
        }
        attributeMethodsCache.put(annotationType, methods);
        return methods;
    }

    static Annotation getAnnotation(AnnotatedElement element, String annotationName) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    static boolean isAttributeMethod(Method method) {
        return method != null && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    static boolean isAnnotationTypeMethod(Method method) {
        return method != null && method.getName().equals("annotationType") && method.getParameterTypes().length == 0;
    }

    static void postProcessAnnotationAttributes(AnnotatedElement element, AnnotationAttributes attributes, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        if (attributes == null) {
            return;
        }
        Class<? extends Annotation> annotationType = attributes.annotationType();
        Map<String, String> aliasMap = AnnotationUtils.getAttributeAliasMap(annotationType);
        HashSet<String> validated = new HashSet<String>();
        for (String attributeName : aliasMap.keySet()) {
            Object aliasedValue;
            String aliasedAttributeName = aliasMap.get(attributeName);
            if (!validated.add(attributeName) || !validated.add(aliasedAttributeName)) continue;
            Object value = attributes.get(attributeName);
            if (!ObjectUtils.nullSafeEquals(value, aliasedValue = attributes.get(aliasedAttributeName)) && value != DEFAULT_VALUE_PLACEHOLDER && aliasedValue != DEFAULT_VALUE_PLACEHOLDER) {
                String elementAsString = element == null ? "unknown element" : element.toString();
                String msg = String.format("In AnnotationAttributes for annotation [%s] declared on [%s], attribute [%s] and its alias [%s] are declared with values of [%s] and [%s], but only one declaration is permitted.", annotationType.getName(), elementAsString, attributeName, aliasedAttributeName, ObjectUtils.nullSafeToString(value), ObjectUtils.nullSafeToString(aliasedValue));
                throw new AnnotationConfigurationException(msg);
            }
            if (value == DEFAULT_VALUE_PLACEHOLDER) {
                attributes.put(attributeName, AnnotationUtils.adaptValue(element, aliasedValue, classValuesAsString, nestedAnnotationsAsMap));
            }
            if (aliasedValue != DEFAULT_VALUE_PLACEHOLDER) continue;
            attributes.put(aliasedAttributeName, AnnotationUtils.adaptValue(element, value, classValuesAsString, nestedAnnotationsAsMap));
        }
        for (String attributeName : attributes.keySet()) {
            Object value = attributes.get(attributeName);
            if (value != DEFAULT_VALUE_PLACEHOLDER) continue;
            attributes.put(attributeName, AnnotationUtils.adaptValue(element, AnnotationUtils.getDefaultValue(annotationType, attributeName), classValuesAsString, nestedAnnotationsAsMap));
        }
    }

    static void rethrowAnnotationConfigurationException(Throwable ex) {
        if (ex instanceof AnnotationConfigurationException) {
            throw (AnnotationConfigurationException)ex;
        }
    }

    static void handleIntrospectionFailure(AnnotatedElement element, Exception ex) {
        AnnotationUtils.rethrowAnnotationConfigurationException(ex);
        Log loggerToUse = logger;
        if (loggerToUse == null) {
            logger = loggerToUse = LogFactory.getLog(AnnotationUtils.class);
        }
        if (element instanceof Class && Annotation.class.isAssignableFrom((Class)element)) {
            if (loggerToUse.isDebugEnabled()) {
                loggerToUse.debug((Object)("Failed to introspect meta-annotations on [" + element + "]: " + ex));
            }
        } else if (loggerToUse.isInfoEnabled()) {
            loggerToUse.info((Object)("Failed to introspect annotations on [" + element + "]: " + ex));
        }
    }

    private static class AnnotationCollector<A extends Annotation> {
        private static final String REPEATABLE_CLASS_NAME = "java.lang.annotation.Repeatable";
        private final Class<A> annotationType;
        private final Class<? extends Annotation> containerAnnotationType;
        private final boolean declaredMode;
        private final Set<AnnotatedElement> visited = new HashSet<AnnotatedElement>();
        private final Set<A> result = new LinkedHashSet<A>();

        AnnotationCollector(Class<A> annotationType, Class<? extends Annotation> containerAnnotationType, boolean declaredMode) {
            this.annotationType = annotationType;
            this.containerAnnotationType = containerAnnotationType != null ? containerAnnotationType : AnnotationCollector.resolveContainerAnnotationType(annotationType);
            this.declaredMode = declaredMode;
        }

        static Class<? extends Annotation> resolveContainerAnnotationType(Class<? extends Annotation> annotationType) {
            try {
                Annotation repeatable = AnnotationUtils.getAnnotation(annotationType, REPEATABLE_CLASS_NAME);
                if (repeatable != null) {
                    Object value = AnnotationUtils.getValue(repeatable);
                    return (Class)value;
                }
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(annotationType, ex);
            }
            return null;
        }

        Set<A> getResult(AnnotatedElement element) {
            this.process(element);
            return Collections.unmodifiableSet(this.result);
        }

        private void process(AnnotatedElement element) {
            if (this.visited.add(element)) {
                try {
                    Annotation[] annotations;
                    for (Annotation ann : annotations = this.declaredMode ? element.getDeclaredAnnotations() : element.getAnnotations()) {
                        Class<? extends Annotation> currentAnnotationType = ann.annotationType();
                        if (ObjectUtils.nullSafeEquals(this.annotationType, currentAnnotationType)) {
                            this.result.add(AnnotationUtils.synthesizeAnnotation(ann, element));
                            continue;
                        }
                        if (ObjectUtils.nullSafeEquals(this.containerAnnotationType, currentAnnotationType)) {
                            this.result.addAll(this.getValue(element, ann));
                            continue;
                        }
                        if (AnnotationUtils.isInJavaLangAnnotationPackage(ann)) continue;
                        this.process(currentAnnotationType);
                    }
                }
                catch (Exception ex) {
                    AnnotationUtils.handleIntrospectionFailure(element, ex);
                }
            }
        }

        private List<A> getValue(AnnotatedElement element, Annotation annotation) {
            try {
                ArrayList<Annotation> synthesizedAnnotations = new ArrayList<Annotation>();
                for (Annotation anno : (Annotation[])AnnotationUtils.getValue(annotation)) {
                    synthesizedAnnotations.add(AnnotationUtils.synthesizeAnnotation(anno, element));
                }
                return synthesizedAnnotations;
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(element, ex);
                return Collections.emptyList();
            }
        }
    }

    private static class AnnotationCacheKey {
        private final AnnotatedElement element;
        private final Class<? extends Annotation> annotationType;

        public AnnotationCacheKey(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            this.element = element;
            this.annotationType = annotationType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationCacheKey)) {
                return false;
            }
            AnnotationCacheKey otherKey = (AnnotationCacheKey)other;
            return this.element.equals(otherKey.element) && ObjectUtils.nullSafeEquals(this.annotationType, otherKey.annotationType);
        }

        public int hashCode() {
            return this.element.hashCode() * 29 + this.annotationType.hashCode();
        }
    }
}

