/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceDecoder
extends AbstractDecoder<Resource> {
    public ResourceDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, MimeType mimeType) {
        Class<ByteArrayResource> clazz = elementType.getRawClass();
        return (InputStreamResource.class.equals(clazz) || clazz.isAssignableFrom(ByteArrayResource.class)) && super.canDecode(elementType, mimeType);
    }

    @Override
    public Flux<Resource> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        Class<ByteArrayResource> clazz = elementType.getRawClass();
        Mono byteArray = Flux.from(inputStream).reduce((rec$, xva$0) -> ((DataBuffer)rec$).write((DataBuffer)xva$0)).map(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release(dataBuffer);
            return bytes;
        });
        if (InputStreamResource.class.equals(clazz)) {
            return Flux.from((Publisher)byteArray.map(ByteArrayInputStream::new).map(InputStreamResource::new));
        }
        if (clazz.isAssignableFrom(ByteArrayResource.class)) {
            return Flux.from((Publisher)byteArray.map(ByteArrayResource::new));
        }
        return Flux.error((Throwable)new IllegalStateException("Unsupported resource class: " + clazz));
    }
}

