/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

public abstract class DataBufferUtils {
    private static final Consumer<ReadableByteChannel> CLOSE_CONSUMER = channel -> {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    };

    public static Flux<DataBuffer> read(InputStream inputStream, DataBufferFactory dataBufferFactory, int bufferSize) {
        Assert.notNull((Object)inputStream, "InputStream must not be null");
        Assert.notNull((Object)dataBufferFactory, "DataBufferFactory must not be null");
        ReadableByteChannel channel = Channels.newChannel(inputStream);
        return DataBufferUtils.read(channel, dataBufferFactory, bufferSize);
    }

    public static Flux<DataBuffer> read(ReadableByteChannel channel, DataBufferFactory dataBufferFactory, int bufferSize) {
        Assert.notNull((Object)channel, "ReadableByteChannel must not be null");
        Assert.notNull((Object)dataBufferFactory, "DataBufferFactory must not be null");
        return Flux.generate(() -> channel, (BiFunction)new ReadableByteChannelGenerator(dataBufferFactory, bufferSize), CLOSE_CONSUMER);
    }

    public static Flux<DataBuffer> takeUntilByteCount(Publisher<DataBuffer> publisher, long maxByteCount) {
        Assert.notNull(publisher, "Publisher must not be null");
        Assert.isTrue(maxByteCount >= 0L, "'maxByteCount' must be a positive number");
        AtomicLong byteCountDown = new AtomicLong(maxByteCount);
        return Flux.from(publisher).takeWhile(dataBuffer -> {
            int delta = -dataBuffer.readableByteCount();
            long currentCount = byteCountDown.getAndAdd(delta);
            return currentCount >= 0L;
        }).map(dataBuffer -> {
            long currentCount = byteCountDown.get();
            if (currentCount >= 0L) {
                return dataBuffer;
            }
            int size = (int)(currentCount + (long)dataBuffer.readableByteCount());
            return dataBuffer.slice(0, size);
        });
    }

    public static Flux<DataBuffer> skipUntilByteCount(Publisher<DataBuffer> publisher, long maxByteCount) {
        Assert.notNull(publisher, "Publisher must not be null");
        Assert.isTrue(maxByteCount >= 0L, "'maxByteCount' must be a positive number");
        AtomicLong byteCountDown = new AtomicLong(maxByteCount);
        return Flux.from(publisher).skipUntil(dataBuffer -> {
            int delta = -dataBuffer.readableByteCount();
            long currentCount = byteCountDown.addAndGet(delta);
            if (currentCount < 0L) {
                return true;
            }
            DataBufferUtils.release(dataBuffer);
            return false;
        }).map(dataBuffer -> {
            long currentCount = byteCountDown.get();
            if (currentCount < 0L) {
                int skip = (int)(currentCount + (long)dataBuffer.readableByteCount());
                byteCountDown.set(0L);
                return dataBuffer.slice(skip, dataBuffer.readableByteCount() - skip);
            }
            return dataBuffer;
        });
    }

    public static <T extends DataBuffer> T retain(T dataBuffer) {
        if (dataBuffer instanceof PooledDataBuffer) {
            return (T)((PooledDataBuffer)dataBuffer).retain();
        }
        return dataBuffer;
    }

    public static boolean release(DataBuffer dataBuffer) {
        if (dataBuffer instanceof PooledDataBuffer) {
            return ((PooledDataBuffer)dataBuffer).release();
        }
        return false;
    }

    private static class ReadableByteChannelGenerator
    implements BiFunction<ReadableByteChannel, SynchronousSink<DataBuffer>, ReadableByteChannel> {
        private final DataBufferFactory dataBufferFactory;
        private final int chunkSize;

        public ReadableByteChannelGenerator(DataBufferFactory dataBufferFactory, int chunkSize) {
            this.dataBufferFactory = dataBufferFactory;
            this.chunkSize = chunkSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadableByteChannel apply(ReadableByteChannel channel, SynchronousSink<DataBuffer> sub) {
            block7: {
                try {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(this.chunkSize);
                    int read = channel.read(byteBuffer);
                    if (read >= 0) {
                        byteBuffer.flip();
                        boolean release = true;
                        DataBuffer dataBuffer = this.dataBufferFactory.allocateBuffer(read);
                        try {
                            dataBuffer.write(byteBuffer);
                            release = false;
                            sub.next((Object)dataBuffer);
                            break block7;
                        }
                        finally {
                            if (release) {
                                DataBufferUtils.release(dataBuffer);
                            }
                        }
                    }
                    sub.complete();
                }
                catch (IOException ex) {
                    sub.error((Throwable)ex);
                }
            }
            return channel;
        }
    }
}

