/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.nio.ByteBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.util.Assert;

public class DefaultDataBufferFactory
implements DataBufferFactory {
    public static final int DEFAULT_INITIAL_CAPACITY = 256;
    private final boolean preferDirect;
    private final int defaultInitialCapacity;

    public DefaultDataBufferFactory() {
        this(false);
    }

    public DefaultDataBufferFactory(boolean preferDirect) {
        this(preferDirect, 256);
    }

    public DefaultDataBufferFactory(boolean preferDirect, int defaultInitialCapacity) {
        Assert.isTrue(defaultInitialCapacity > 0, "'defaultInitialCapacity' should be larger than 0");
        this.preferDirect = preferDirect;
        this.defaultInitialCapacity = defaultInitialCapacity;
    }

    @Override
    public DefaultDataBuffer allocateBuffer() {
        return this.allocateBuffer(this.defaultInitialCapacity);
    }

    @Override
    public DefaultDataBuffer allocateBuffer(int initialCapacity) {
        return this.preferDirect ? new DefaultDataBuffer(ByteBuffer.allocateDirect(initialCapacity), this) : new DefaultDataBuffer(ByteBuffer.allocate(initialCapacity), this);
    }

    @Override
    public DefaultDataBuffer wrap(ByteBuffer byteBuffer) {
        ByteBuffer sliced = byteBuffer.slice();
        return new DefaultDataBuffer(sliced, 0, byteBuffer.remaining(), this);
    }

    public String toString() {
        return "DefaultDataBufferFactory (preferDirect=" + this.preferDirect + ")";
    }
}

