/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultDataBuffer
implements DataBuffer {
    private final DefaultDataBufferFactory dataBufferFactory;
    private ByteBuffer byteBuffer;
    private int readPosition;
    private int writePosition;

    DefaultDataBuffer(ByteBuffer byteBuffer, DefaultDataBufferFactory dataBufferFactory) {
        this(byteBuffer, byteBuffer.position(), byteBuffer.position(), dataBufferFactory);
    }

    DefaultDataBuffer(ByteBuffer byteBuffer, int readPosition, int writePosition, DefaultDataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)byteBuffer, "'byteBuffer' must not be null");
        Assert.isTrue(readPosition >= 0, "'readPosition' must be 0 or higher");
        Assert.isTrue(writePosition >= 0, "'writePosition' must be 0 or higher");
        Assert.isTrue(readPosition <= writePosition, "'readPosition' must be smaller than or equal to 'writePosition'");
        Assert.notNull((Object)dataBufferFactory, "'dataBufferFactory' must not be null");
        this.byteBuffer = byteBuffer;
        this.readPosition = readPosition;
        this.writePosition = writePosition;
        this.dataBufferFactory = dataBufferFactory;
    }

    public ByteBuffer getNativeBuffer() {
        return this.byteBuffer;
    }

    @Override
    public DefaultDataBufferFactory factory() {
        return this.dataBufferFactory;
    }

    @Override
    public int indexOf(IntPredicate predicate, int fromIndex) {
        Assert.notNull((Object)predicate, "'predicate' must not be null");
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.writePosition) {
            return -1;
        }
        for (int i = fromIndex; i < this.writePosition; ++i) {
            byte b = this.byteBuffer.get(i);
            if (!predicate.test(b)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(IntPredicate predicate, int fromIndex) {
        Assert.notNull((Object)predicate, "'predicate' must not be null");
        for (int i = Math.min(fromIndex, this.writePosition - 1); i >= 0; --i) {
            byte b = this.byteBuffer.get(i);
            if (!predicate.test(b)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int readableByteCount() {
        return this.writePosition - this.readPosition;
    }

    @Override
    public byte read() {
        return this.readInternal(ByteBuffer::get);
    }

    @Override
    public DefaultDataBuffer read(byte[] destination) {
        Assert.notNull((Object)destination, "'destination' must not be null");
        this.readInternal(b -> b.get(destination));
        return this;
    }

    @Override
    public DefaultDataBuffer read(byte[] destination, int offset, int length) {
        Assert.notNull((Object)destination, "'destination' must not be null");
        this.readInternal(b -> b.get(destination, offset, length));
        return this;
    }

    private <T> T readInternal(Function<ByteBuffer, T> function) {
        ((Buffer)this.byteBuffer).position(this.readPosition);
        try {
            T t = function.apply(this.byteBuffer);
            return t;
        }
        finally {
            this.readPosition = this.byteBuffer.position();
        }
    }

    @Override
    public DefaultDataBuffer write(byte b) {
        this.ensureExtraCapacity(1);
        this.writeInternal(buffer -> buffer.put(b));
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte[] source) {
        Assert.notNull((Object)source, "'source' must not be null");
        this.ensureExtraCapacity(source.length);
        this.writeInternal(buffer -> buffer.put(source));
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte[] source, int offset, int length) {
        Assert.notNull((Object)source, "'source' must not be null");
        this.ensureExtraCapacity(length);
        this.writeInternal(buffer -> buffer.put(source, offset, length));
        return this;
    }

    @Override
    public DataBuffer write(DataBuffer ... buffers) {
        if (!ObjectUtils.isEmpty(buffers)) {
            ByteBuffer[] byteBuffers = (ByteBuffer[])Arrays.stream(buffers).map(DataBuffer::asByteBuffer).toArray(ByteBuffer[]::new);
            this.write(byteBuffers);
        }
        return this;
    }

    @Override
    public DefaultDataBuffer write(ByteBuffer ... byteBuffers) {
        Assert.notEmpty((Object[])byteBuffers, "'byteBuffers' must not be empty");
        int extraCapacity = Arrays.stream(byteBuffers).mapToInt(Buffer::remaining).sum();
        this.ensureExtraCapacity(extraCapacity);
        Arrays.stream(byteBuffers).forEach(byteBuffer -> this.writeInternal(buffer -> buffer.put((ByteBuffer)byteBuffer)));
        return this;
    }

    private <T> T writeInternal(Function<ByteBuffer, T> function) {
        ((Buffer)this.byteBuffer).position(this.writePosition);
        try {
            T t = function.apply(this.byteBuffer);
            return t;
        }
        finally {
            this.writePosition = this.byteBuffer.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataBuffer slice(int index, int length) {
        int oldPosition = this.byteBuffer.position();
        ByteBuffer buffer = this.byteBuffer;
        try {
            ((Buffer)buffer).position(index);
            ByteBuffer slice = this.byteBuffer.slice();
            ((Buffer)slice).limit(length);
            SlicedDefaultDataBuffer slicedDefaultDataBuffer = new SlicedDefaultDataBuffer(slice, 0, length, this.dataBufferFactory);
            return slicedDefaultDataBuffer;
        }
        finally {
            ((Buffer)buffer).position(oldPosition);
        }
    }

    @Override
    public ByteBuffer asByteBuffer() {
        ByteBuffer duplicate;
        ByteBuffer buffer = duplicate = this.byteBuffer.duplicate();
        ((Buffer)buffer).position(this.readPosition);
        ((Buffer)buffer).limit(this.writePosition);
        return duplicate;
    }

    @Override
    public InputStream asInputStream() {
        return new DefaultDataBufferInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return new DefaultDataBufferOutputStream();
    }

    private void ensureExtraCapacity(int extraCapacity) {
        int neededCapacity = this.writePosition + extraCapacity;
        if (neededCapacity > this.byteBuffer.capacity()) {
            this.grow(neededCapacity);
        }
    }

    void grow(int minCapacity) {
        ByteBuffer oldBuffer = this.byteBuffer;
        ByteBuffer newBuffer = oldBuffer.isDirect() ? ByteBuffer.allocateDirect(minCapacity) : ByteBuffer.allocate(minCapacity);
        int remaining = this.readableByteCount();
        ((Buffer)oldBuffer).position(this.readPosition).limit(this.writePosition);
        newBuffer.put(oldBuffer);
        this.byteBuffer = newBuffer;
        this.readPosition = 0;
        this.writePosition = remaining;
        oldBuffer.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultDataBuffer)) {
            return false;
        }
        DefaultDataBuffer other = (DefaultDataBuffer)obj;
        return this.readPosition == other.readPosition && this.writePosition == other.writePosition && this.byteBuffer.equals(other.byteBuffer);
    }

    public int hashCode() {
        return this.byteBuffer.hashCode();
    }

    public String toString() {
        return this.byteBuffer.toString();
    }

    private static class SlicedDefaultDataBuffer
    extends DefaultDataBuffer {
        SlicedDefaultDataBuffer(ByteBuffer byteBuffer, int readPosition, int writePosition, DefaultDataBufferFactory dataBufferFactory) {
            super(byteBuffer, readPosition, writePosition, dataBufferFactory);
        }

        @Override
        void grow(int minCapacity) {
            throw new UnsupportedOperationException("Growing the capacity of a sliced buffer is not supported");
        }
    }

    private class DefaultDataBufferOutputStream
    extends OutputStream {
        private DefaultDataBufferOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            DefaultDataBuffer.this.ensureExtraCapacity(1);
            DefaultDataBuffer.this.writeInternal(buffer -> buffer.put((byte)b));
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            DefaultDataBuffer.this.ensureExtraCapacity(len);
            DefaultDataBuffer.this.writeInternal(buffer -> buffer.put(bytes, off, len));
        }
    }

    private class DefaultDataBufferInputStream
    extends InputStream {
        private DefaultDataBufferInputStream() {
        }

        @Override
        public int available() throws IOException {
            return DefaultDataBuffer.this.readableByteCount();
        }

        @Override
        public int read() {
            return (Integer)DefaultDataBuffer.this.readInternal(buffer -> DefaultDataBuffer.this.readableByteCount() > 0 ? buffer.get() & 0xFF : -1);
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            return (Integer)DefaultDataBuffer.this.readInternal(buffer -> {
                int count = DefaultDataBuffer.this.readableByteCount();
                if (count > 0) {
                    int minLen = Math.min(len, count);
                    buffer.get(bytes, off, minLen);
                    return minLen;
                }
                return -1;
            });
        }
    }
}

