/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.events.XMLEvent;
import org.springframework.util.Assert;
import org.springframework.util.xml.AbstractXMLEventReader;

class ListBasedXMLEventReader
extends AbstractXMLEventReader {
    private final List<XMLEvent> events;
    private int cursor = 0;

    public ListBasedXMLEventReader(List<XMLEvent> events) {
        Assert.notNull(events, "'events' must not be null");
        this.events = Collections.unmodifiableList(events);
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.events.size();
    }

    @Override
    public XMLEvent nextEvent() {
        if (this.cursor < this.events.size()) {
            return this.events.get(this.cursor++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public XMLEvent peek() {
        if (this.cursor < this.events.size()) {
            return this.events.get(this.cursor);
        }
        return null;
    }

    @Override
    public void close() {
        super.close();
        this.events.clear();
    }
}

