/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class KotlinReflectionParameterNameDiscoverer
implements ParameterNameDiscoverer {
    @Nullable
    private static final Class<?> kotlinMetadata;

    @Override
    @Nullable
    public String[] getParameterNames(Method method) {
        if (!KotlinReflectionParameterNameDiscoverer.useKotlinSupport(method.getDeclaringClass())) {
            return null;
        }
        KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
        return function != null ? this.getParameterNames(function.getParameters()) : null;
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> ctor) {
        if (!KotlinReflectionParameterNameDiscoverer.useKotlinSupport(ctor.getDeclaringClass())) {
            return null;
        }
        KFunction function = ReflectJvmMapping.getKotlinFunction(ctor);
        return function != null ? this.getParameterNames(function.getParameters()) : null;
    }

    @Nullable
    private String[] getParameterNames(List<KParameter> parameters) {
        List filteredParameters = parameters.stream().filter(p -> KParameter.Kind.VALUE.equals((Object)p.getKind())).collect(Collectors.toList());
        String[] parameterNames = new String[filteredParameters.size()];
        for (int i = 0; i < filteredParameters.size(); ++i) {
            String name = ((KParameter)filteredParameters.get(i)).getName();
            if (name == null) {
                return null;
            }
            parameterNames[i] = name;
        }
        return parameterNames;
    }

    private static boolean useKotlinSupport(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    static {
        Class<?> metadata;
        try {
            metadata = ClassUtils.forName("kotlin.Metadata", KotlinReflectionParameterNameDiscoverer.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            metadata = null;
        }
        kotlinMetadata = metadata;
    }
}

