/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;

final class AnnotationTypeMappings {
    private static final IntrospectionFailureLogger failureLogger = IntrospectionFailureLogger.DEBUG;
    private static final Map<AnnotationFilter, Cache> cache = new ConcurrentReferenceHashMap<AnnotationFilter, Cache>();
    private final AnnotationFilter filter;
    private final List<AnnotationTypeMapping> mappings;

    private AnnotationTypeMappings(AnnotationFilter filter, Class<? extends Annotation> annotationType) {
        this.filter = filter;
        this.mappings = new ArrayList<AnnotationTypeMapping>();
        this.addAllMappings(annotationType);
        this.mappings.forEach(AnnotationTypeMapping::afterAllMappingsSet);
    }

    private void addAllMappings(Class<? extends Annotation> annotationType) {
        ArrayDeque<AnnotationTypeMapping> queue = new ArrayDeque<AnnotationTypeMapping>();
        this.addIfPossible(queue, null, annotationType, null);
        while (!queue.isEmpty()) {
            AnnotationTypeMapping mapping = (AnnotationTypeMapping)queue.removeFirst();
            this.mappings.add(mapping);
            this.addMetaAnnotationsToQueue(queue, mapping);
        }
    }

    private void addMetaAnnotationsToQueue(Deque<AnnotationTypeMapping> queue, AnnotationTypeMapping parent) {
        Annotation[] metaAnnotations;
        for (Annotation metaAnnotation : metaAnnotations = AnnotationsScanner.getDeclaredAnnotations(parent.getAnnotationType(), false)) {
            if (!this.isMappable(parent, metaAnnotation)) continue;
            Annotation[] repeatedAnnotations = RepeatableContainers.standardRepeatables().findRepeatedAnnotations(metaAnnotation);
            if (repeatedAnnotations != null) {
                for (Annotation repeatedAnnotation : repeatedAnnotations) {
                    if (!this.isMappable(parent, metaAnnotation)) continue;
                    this.addIfPossible(queue, parent, repeatedAnnotation);
                }
                continue;
            }
            this.addIfPossible(queue, parent, metaAnnotation);
        }
    }

    private void addIfPossible(Deque<AnnotationTypeMapping> queue, AnnotationTypeMapping parent, Annotation ann) {
        this.addIfPossible(queue, parent, ann.annotationType(), ann);
    }

    private void addIfPossible(Deque<AnnotationTypeMapping> queue, @Nullable AnnotationTypeMapping parent, Class<? extends Annotation> annotationType, @Nullable Annotation ann) {
        block3: {
            try {
                queue.addLast(new AnnotationTypeMapping(parent, annotationType, ann));
            }
            catch (Exception ex) {
                if (ex instanceof AnnotationConfigurationException) {
                    throw (AnnotationConfigurationException)ex;
                }
                if (!failureLogger.isEnabled()) break block3;
                failureLogger.log("Failed to introspect meta-annotation " + annotationType.getName(), parent != null ? parent.getAnnotationType() : null, ex);
            }
        }
    }

    private boolean isMappable(AnnotationTypeMapping parent, @Nullable Annotation metaAnnotation) {
        return metaAnnotation != null && !this.filter.matches(metaAnnotation) && !AnnotationFilter.PLAIN.matches(parent.getAnnotationType()) && !this.isAlreadyMapped(parent, metaAnnotation);
    }

    private boolean isAlreadyMapped(AnnotationTypeMapping parent, Annotation metaAnnotation) {
        Class<? extends Annotation> annotationType = metaAnnotation.annotationType();
        for (AnnotationTypeMapping mapping = parent; mapping != null; mapping = mapping.getParent()) {
            if (mapping.getAnnotationType() != annotationType) continue;
            return true;
        }
        return false;
    }

    int size() {
        return this.mappings.size();
    }

    AnnotationTypeMapping get(int index) {
        return this.mappings.get(index);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> annotationType) {
        return AnnotationTypeMappings.forAnnotationType(annotationType, AnnotationFilter.PLAIN);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> annotationType, AnnotationFilter annotationFilter) {
        return cache.computeIfAbsent(annotationFilter, Cache::new).get(annotationType);
    }

    static void clearCache() {
        cache.clear();
    }

    private static class Cache {
        private final AnnotationFilter filter;
        private final Map<Class<? extends Annotation>, AnnotationTypeMappings> mappings;

        Cache(AnnotationFilter filter) {
            this.filter = filter;
            this.mappings = new ConcurrentReferenceHashMap<Class<? extends Annotation>, AnnotationTypeMappings>();
        }

        AnnotationTypeMappings get(Class<? extends Annotation> annotationType) {
            return this.mappings.computeIfAbsent(annotationType, this::createMappings);
        }

        AnnotationTypeMappings createMappings(Class<? extends Annotation> annotationType) {
            return new AnnotationTypeMappings(this.filter, annotationType);
        }
    }
}

