/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.aot.hint.annotation.RegisterReflection;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RegisterReflectionReflectiveProcessor
implements ReflectiveProcessor {
    private static final Log logger = LogFactory.getLog(RegisterReflectionReflectiveProcessor.class);

    @Override
    public final void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        RegisterReflection annotation = AnnotatedElementUtils.getMergedAnnotation(element, RegisterReflection.class);
        Assert.notNull((Object)annotation, () -> "Element must be annotated with @RegisterReflection: " + element);
        ReflectionRegistration registration = this.parse(element, annotation);
        this.registerReflectionHints(hints, registration);
    }

    protected ReflectionRegistration parse(AnnotatedElement element, RegisterReflection annotation) {
        ArrayList<Class> allClassNames = new ArrayList<Class>();
        allClassNames.addAll(Arrays.asList(annotation.classes()));
        allClassNames.addAll(Arrays.stream(annotation.classNames()).map(this::loadClass).filter(Objects::nonNull).toList());
        if (allClassNames.isEmpty()) {
            if (element instanceof Class) {
                Class clazz = (Class)element;
                allClassNames.add(clazz);
            } else {
                throw new IllegalStateException("At least one class must be specified: " + element);
            }
        }
        return new ReflectionRegistration(allClassNames.toArray(new Class[0]), annotation.memberCategories());
    }

    protected void registerReflectionHints(ReflectionHints hints, ReflectionRegistration registration) {
        for (Class<?> target : registration.classes) {
            this.registerReflectionHints(hints, target, registration.memberCategories);
        }
    }

    protected void registerReflectionHints(ReflectionHints hints, Class<?> target, MemberCategory[] memberCategories) {
        hints.registerType(target, type -> type.withMembers(memberCategories));
    }

    @Nullable
    private Class<?> loadClass(String className) {
        try {
            return ClassUtils.forName(className, this.getClass().getClassLoader());
        }
        catch (Exception ex) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Ignoring '" + className + "': " + ex));
            }
            return null;
        }
    }

    protected record ReflectionRegistration(Class<?>[] classes, MemberCategory[] memberCategories) {
    }
}

