/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.VfsPatternUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    private static final Log logger = LogFactory.getLog(PathMatchingResourcePatternResolver.class);
    private static final Set<String> systemModuleNames = NativeDetector.inNativeImage() ? Collections.emptySet() : ModuleFinder.ofSystem().findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
    private static final Predicate<ResolvedModule> isNotSystemModule = resolvedModule -> !systemModuleNames.contains(resolvedModule.name());
    private static @Nullable Method equinoxResolveMethod;
    private final ResourceLoader resourceLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, Resource[]> rootDirCache = new ConcurrentHashMap<String, Resource[]>();
    private final Map<String, NavigableSet<String>> jarEntriesCache = new ConcurrentHashMap<String, NavigableSet<String>>();
    private volatile @Nullable Set<ClassPathManifestEntry> manifestEntriesCache;

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver(@Nullable ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public @Nullable ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    @Override
    public Resource[] getResources(String locationPattern) throws IOException {
        int prefixEnd;
        Assert.notNull((Object)locationPattern, "Location pattern must not be null");
        if (locationPattern.startsWith("classpath*:")) {
            String locationPatternWithoutPrefix = locationPattern.substring("classpath*:".length());
            Set<Resource> resources = this.findAllModulePathResources(locationPatternWithoutPrefix);
            if (this.getPathMatcher().isPattern(locationPatternWithoutPrefix)) {
                Collections.addAll(resources, this.findPathMatchingResources(locationPattern));
            } else {
                Collections.addAll(resources, this.findAllClassPathResources(locationPatternWithoutPrefix));
            }
            return resources.toArray(new Resource[0]);
        }
        int n = prefixEnd = locationPattern.startsWith("war:") ? locationPattern.indexOf("*/") + 1 : locationPattern.indexOf(58) + 1;
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResourceLoader().getResource(locationPattern)};
    }

    public void clearCache() {
        this.rootDirCache.clear();
        this.jarEntriesCache.clear();
        this.manifestEntriesCache = null;
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        String path = PathMatchingResourcePatternResolver.stripLeadingSlash(location);
        Set<Resource> result = this.doFindAllClassPathResources(path);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved class path location [" + path + "] to resources " + String.valueOf(result)));
        }
        return result.toArray(new Resource[0]);
    }

    protected Set<Resource> doFindAllClassPathResources(String path) throws IOException {
        Enumeration<URL> resourceUrls;
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        ClassLoader cl = this.getClassLoader();
        Enumeration<URL> enumeration = resourceUrls = cl != null ? cl.getResources(path) : ClassLoader.getSystemResources(path);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(this.convertClassLoaderURL(url));
        }
        if (!StringUtils.hasLength(path)) {
            this.addAllClassLoaderJarRoots(cl, result);
        }
        return result;
    }

    protected Resource convertClassLoaderURL(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                return new FileSystemResource(ResourceUtils.toURI(url).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new FileSystemResource(url.getFile());
            }
        }
        String urlString = url.toString();
        String cleanedPath = StringUtils.cleanPath(urlString);
        if (!cleanedPath.equals(urlString)) {
            try {
                return new UrlResource(new URL(url, cleanedPath));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new UrlResource(url);
    }

    protected void addAllClassLoaderJarRoots(@Nullable ClassLoader classLoader, Set<Resource> result) {
        block11: {
            block10: {
                if (classLoader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                    try {
                        for (URL url : urlClassLoader.getURLs()) {
                            try {
                                UrlResource jarResource;
                                UrlResource urlResource = jarResource = "jar".equals(url.getProtocol()) ? new UrlResource(url) : new UrlResource("jar:" + String.valueOf(url) + "!/");
                                if (!jarResource.exists()) continue;
                                result.add(jarResource);
                            }
                            catch (MalformedURLException ex) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("Cannot search for matching files underneath [" + String.valueOf(url) + "] because it cannot be converted to a valid 'jar:' URL: " + ex.getMessage()));
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.debug((Object)("Cannot introspect jar files since ClassLoader [" + String.valueOf(classLoader) + "] does not support 'getURLs()': " + String.valueOf(ex)));
                    }
                }
            }
            if (classLoader == ClassLoader.getSystemClassLoader()) {
                this.addClassPathManifestEntries(result);
            }
            if (classLoader != null) {
                try {
                    this.addAllClassLoaderJarRoots(classLoader.getParent(), result);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)("Cannot introspect jar files in parent ClassLoader since [" + String.valueOf(classLoader) + "] does not support 'getParent()': " + String.valueOf(ex)));
                }
            }
        }
    }

    protected void addClassPathManifestEntries(Set<Resource> result) {
        Set<ClassPathManifestEntry> entries = this.manifestEntriesCache;
        if (entries == null) {
            this.manifestEntriesCache = entries = this.getClassPathManifestEntries();
        }
        for (ClassPathManifestEntry entry : entries) {
            if (result.contains(entry.resource()) || entry.alternative() == null || result.contains(entry.alternative())) continue;
            result.add(entry.resource());
        }
    }

    private Set<ClassPathManifestEntry> getClassPathManifestEntries() {
        LinkedHashSet<ClassPathManifestEntry> manifestEntries = new LinkedHashSet<ClassPathManifestEntry>();
        HashSet<File> seen = new HashSet<File>();
        try {
            String paths = System.getProperty("java.class.path");
            for (String path : StringUtils.delimitedListToStringArray(paths, File.pathSeparator)) {
                try {
                    File jar = new File(path).getAbsoluteFile();
                    if (!jar.isFile() || !seen.add(jar)) continue;
                    manifestEntries.add(ClassPathManifestEntry.of(jar));
                    manifestEntries.addAll(this.getClassPathManifestEntriesFromJar(jar));
                }
                catch (MalformedURLException ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Cannot search for matching files underneath [" + path + "] because it cannot be converted to a valid 'jar:' URL: " + ex.getMessage()));
                }
            }
            return Collections.unmodifiableSet(manifestEntries);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to evaluate 'java.class.path' manifest entries: " + String.valueOf(ex)));
            }
            return Collections.emptySet();
        }
    }

    private Set<ClassPathManifestEntry> getClassPathManifestEntriesFromJar(File jar) throws IOException {
        Set<ClassPathManifestEntry> set;
        URL base = jar.toURI().toURL();
        File parent = jar.getAbsoluteFile().getParentFile();
        JarFile jarFile = new JarFile(jar);
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest != null ? manifest.getMainAttributes() : null;
            String classPath = attributes != null ? attributes.getValue(Attributes.Name.CLASS_PATH) : null;
            LinkedHashSet<ClassPathManifestEntry> manifestEntries = new LinkedHashSet<ClassPathManifestEntry>();
            if (StringUtils.hasLength(classPath)) {
                StringTokenizer tokenizer = new StringTokenizer(classPath);
                while (tokenizer.hasMoreTokens()) {
                    File candidate;
                    String path = tokenizer.nextToken();
                    if (path.indexOf(58) >= 0 && !"file".equalsIgnoreCase(new URL(base, path).getProtocol()) || !(candidate = new File(parent, path)).isFile() || !candidate.getCanonicalPath().contains(parent.getCanonicalPath())) continue;
                    manifestEntries.add(ClassPathManifestEntry.of(candidate));
                }
            }
            set = Collections.unmodifiableSet(manifestEntries);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to load manifest entries from jar file '" + String.valueOf(jar) + "': " + String.valueOf(ex)));
                }
                return Collections.emptySet();
            }
        }
        jarFile.close();
        return set;
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.rootDirCache.get(rootDirPath);
        String actualRootPath = null;
        if (rootDirResources == null) {
            String commonPrefix = null;
            String existingPath = null;
            boolean commonUnique = true;
            for (String path : this.rootDirCache.keySet()) {
                String currentPrefix = null;
                for (int i = 0; i < path.length(); ++i) {
                    if (i != rootDirPath.length() && path.charAt(i) == rootDirPath.charAt(i)) continue;
                    currentPrefix = path.substring(0, path.lastIndexOf(47, i - 1) + 1);
                    break;
                }
                if (currentPrefix != null) {
                    if (!PathMatchingResourcePatternResolver.checkPathWithinPackage(path.substring(currentPrefix.length()))) continue;
                    if (commonPrefix == null || !commonUnique || currentPrefix.length() > commonPrefix.length()) {
                        commonPrefix = currentPrefix;
                        existingPath = path;
                        continue;
                    }
                    if (!currentPrefix.equals(commonPrefix)) continue;
                    commonUnique = false;
                    continue;
                }
                if (actualRootPath != null && path.length() <= actualRootPath.length()) continue;
                rootDirResources = this.rootDirCache.get(path);
                actualRootPath = path;
            }
            if (rootDirResources == null && StringUtils.hasLength(commonPrefix)) {
                rootDirResources = this.getResources(commonPrefix);
                Resource[] existingResources = this.rootDirCache.get(existingPath);
                if (existingResources != null && rootDirResources.length == existingResources.length) {
                    this.rootDirCache.remove(existingPath);
                    this.rootDirCache.put(commonPrefix, rootDirResources);
                    actualRootPath = commonPrefix;
                } else if (commonPrefix.equals(rootDirPath)) {
                    this.rootDirCache.put(rootDirPath, rootDirResources);
                } else {
                    rootDirResources = null;
                }
            }
            if (rootDirResources == null) {
                rootDirResources = this.getResources(rootDirPath);
                this.rootDirCache.put(rootDirPath, rootDirResources);
            }
        }
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(64);
        for (Resource rootDirResource : rootDirResources) {
            if (actualRootPath != null && actualRootPath.length() < rootDirPath.length()) {
                rootDirResource = rootDirResource.createRelative(rootDirPath.substring(actualRootPath.length()));
            }
            rootDirResource = this.resolveRootDirResource(rootDirResource);
            URL rootDirUrl = rootDirResource.getURL();
            if (equinoxResolveMethod != null && rootDirUrl.getProtocol().startsWith("bundle")) {
                URL resolvedUrl = (URL)ReflectionUtils.invokeMethod(equinoxResolveMethod, null, rootDirUrl);
                if (resolvedUrl != null) {
                    rootDirUrl = resolvedUrl;
                }
                rootDirResource = new UrlResource(rootDirUrl);
            }
            if (rootDirUrl.getProtocol().startsWith("vfs")) {
                result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirUrl, subPattern, this.getPathMatcher()));
                continue;
            }
            if (ResourceUtils.isJarURL(rootDirUrl) || this.isJarResource(rootDirResource)) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, rootDirUrl, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved location pattern [" + locationPattern + "] to resources " + String.valueOf(result)));
        }
        return result.toArray(new Resource[0]);
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(58) + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    protected Resource resolveRootDirResource(Resource original) throws IOException {
        return original;
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, URL rootDirUrl, String subPattern) throws IOException {
        boolean closeJarFile;
        JarFile jarFile;
        URLConnection con;
        String jarFileUrl = null;
        Object rootEntryPath = "";
        String urlFile = rootDirUrl.getFile();
        int separatorIndex = urlFile.indexOf("*/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf("!/");
        }
        if (separatorIndex >= 0) {
            jarFileUrl = urlFile.substring(0, separatorIndex);
            rootEntryPath = urlFile.substring(separatorIndex + 2);
            NavigableSet<String> entriesCache = this.jarEntriesCache.get(jarFileUrl);
            if (entriesCache != null) {
                LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(64);
                rootEntryPath = ((String)rootEntryPath).replace("!/", "/");
                for (String entryPath : entriesCache.tailSet((String)rootEntryPath, false)) {
                    if (!entryPath.startsWith((String)rootEntryPath)) break;
                    String relativePath = entryPath.substring(((String)rootEntryPath).length());
                    if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                    result.add(rootDirResource.createRelative(relativePath));
                }
                return result;
            }
        }
        if ((con = rootDirUrl.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            try {
                jarFile = jarCon.getJarFile();
                jarFileUrl = jarCon.getJarFileURL().toExternalForm();
                JarEntry jarEntry = jarCon.getJarEntry();
                rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
                closeJarFile = !jarCon.getUseCaches();
            }
            catch (FileNotFoundException | ZipException ex) {
                return Collections.emptySet();
            }
        }
        try {
            if (jarFileUrl != null) {
                jarFile = this.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            closeJarFile = true;
        }
        catch (ZipException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping invalid jar class path entry [" + urlFile + "]"));
            }
            return Collections.emptySet();
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Looking for matching resources in jar file [" + jarFileUrl + "]"));
            }
            if (StringUtils.hasLength((String)rootEntryPath) && !((String)rootEntryPath).endsWith("/")) {
                rootEntryPath = (String)rootEntryPath + "/";
            }
            LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(64);
            TreeSet<String> entriesCache = new TreeSet<String>();
            Iterator entryIterator = jarFile.stream().map(ZipEntry::getName).sorted().iterator();
            while (entryIterator.hasNext()) {
                String entryPath = (String)entryIterator.next();
                int entrySeparatorIndex = entryPath.indexOf("!/");
                if (entrySeparatorIndex >= 0) {
                    entryPath = entryPath.substring(entrySeparatorIndex + "!/".length());
                }
                entriesCache.add(entryPath);
                if (!entryPath.startsWith((String)rootEntryPath)) continue;
                String relativePath = entryPath.substring(((String)rootEntryPath).length());
                if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                result.add(rootDirResource.createRelative(relativePath));
            }
            this.jarEntriesCache.put(jarFileUrl, entriesCache);
            LinkedHashSet<Resource> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (closeJarFile) {
                jarFile.close();
            }
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        LinkedHashSet<Resource> result;
        block27: {
            Path rootPath;
            block26: {
                URI rootDirUri;
                result = new LinkedHashSet<Resource>(64);
                try {
                    rootDirUri = rootDirResource.getURI();
                }
                catch (Exception ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)"Failed to resolve directory [%s] as URI: %s".formatted(rootDirResource, ex));
                    }
                    return result;
                }
                rootPath = null;
                if (rootDirUri.isAbsolute() && !rootDirUri.isOpaque()) {
                    try {
                        try {
                            rootPath = Path.of(rootDirUri);
                        }
                        catch (FileSystemNotFoundException ex) {
                            FileSystems.newFileSystem(rootDirUri, Map.of(), ClassUtils.getDefaultClassLoader());
                            rootPath = Path.of(rootDirUri);
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block26;
                        logger.debug((Object)"Failed to resolve %s in file system: %s".formatted(rootDirUri, ex));
                    }
                }
            }
            if (rootPath == null) {
                try {
                    rootPath = Path.of(rootDirResource.getFile().getAbsolutePath(), new String[0]);
                }
                catch (FileNotFoundException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Cannot search for matching files underneath " + String.valueOf(rootDirResource) + " in the file system: " + ex.getMessage()));
                    }
                    return result;
                }
                catch (Exception ex) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Failed to resolve " + String.valueOf(rootDirResource) + " in the file system: " + String.valueOf(ex)));
                    }
                    return result;
                }
            }
            if (!Files.exists(rootPath, new LinkOption[0])) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Skipping search for files matching pattern [%s]: directory [%s] does not exist".formatted(subPattern, rootPath.toAbsolutePath()));
                }
                return result;
            }
            Object rootDir = StringUtils.cleanPath(rootPath.toString());
            if (!((String)rootDir).endsWith("/")) {
                rootDir = (String)rootDir + "/";
            }
            Path rootPathForPattern = rootPath;
            String resourcePattern = (String)rootDir + StringUtils.cleanPath(subPattern);
            Predicate<Path> isMatchingFile = path -> !path.equals(rootPathForPattern) && this.getPathMatcher().match(resourcePattern, StringUtils.cleanPath(path.toString()));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Searching directory [%s] for files matching pattern [%s]".formatted(rootPath.toAbsolutePath(), subPattern));
            }
            try (Stream<Path> files = Files.walk(rootPath, FileVisitOption.FOLLOW_LINKS);){
                files.filter(isMatchingFile).sorted().map(FileSystemResource::new).forEach(result::add);
            }
            catch (Exception ex) {
                if (!logger.isWarnEnabled()) break block27;
                logger.warn((Object)"Failed to search in directory [%s] for files matching pattern [%s]: %s".formatted(rootPath.toAbsolutePath(), subPattern, ex));
            }
        }
        return result;
    }

    protected Set<Resource> findAllModulePathResources(String locationPattern) throws IOException {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(64);
        if (NativeDetector.inNativeImage()) {
            return result;
        }
        String resourcePattern = PathMatchingResourcePatternResolver.stripLeadingSlash(locationPattern);
        Predicate<String> resourcePatternMatches = this.getPathMatcher().isPattern(resourcePattern) ? path -> this.getPathMatcher().match(resourcePattern, (String)path) : resourcePattern::equals;
        try {
            ModuleLayer.boot().configuration().modules().stream().filter(isNotSystemModule).forEach(resolvedModule -> {
                try (ModuleReader moduleReader = resolvedModule.reference().open();
                     Stream<String> names = moduleReader.list();){
                    names.filter(resourcePatternMatches).map(name -> this.findResource(moduleReader, (String)name)).filter(Objects::nonNull).forEach(result::add);
                }
                catch (IOException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to read contents of module [%s]".formatted(resolvedModule), (Throwable)ex);
                    }
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Resolved module-path location pattern [%s] to resources %s".formatted(resourcePattern, result));
        }
        return result;
    }

    private @Nullable Resource findResource(ModuleReader moduleReader, String name) {
        try {
            return moduleReader.find(name).map(this::convertModuleSystemURI).orElse(null);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to find resource [%s] in module path".formatted(name), (Throwable)ex);
            }
            return null;
        }
    }

    private Resource convertModuleSystemURI(URI uri) {
        return "file".equals(uri.getScheme()) ? new FileSystemResource(uri.getPath()) : UrlResource.from(uri);
    }

    private static String stripLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private static boolean checkPathWithinPackage(String path) {
        return path.contains("/") && !path.contains("!/");
    }

    static {
        try {
            Class<?> fileLocatorClass = ClassUtils.forName("org.eclipse.core.runtime.FileLocator", PathMatchingResourcePatternResolver.class.getClassLoader());
            equinoxResolveMethod = fileLocatorClass.getMethod("resolve", URL.class);
            logger.trace((Object)"Found Equinox FileLocator for OSGi bundle URL resolution");
        }
        catch (Throwable ex) {
            equinoxResolveMethod = null;
        }
    }

    private record ClassPathManifestEntry(Resource resource, @Nullable Resource alternative) {
        private static final String JARFILE_URL_PREFIX = "jar:file:";

        static ClassPathManifestEntry of(File file) throws MalformedURLException {
            String path = ClassPathManifestEntry.fixPath(file.getAbsolutePath());
            Resource resource = ClassPathManifestEntry.asJarFileResource(path);
            Resource alternative = ClassPathManifestEntry.createAlternative(path);
            return new ClassPathManifestEntry(resource, alternative);
        }

        private static String fixPath(String path) {
            int prefixIndex = ((String)path).indexOf(58);
            if (prefixIndex == 1) {
                path = "/" + StringUtils.capitalize((String)path);
            }
            return StringUtils.replace((String)path, "#", "%23");
        }

        private static @Nullable Resource createAlternative(String path) {
            try {
                Object alternativePath = path.startsWith("/") ? path.substring(1) : "/" + path;
                return ClassPathManifestEntry.asJarFileResource((String)alternativePath);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        private static Resource asJarFileResource(String path) throws MalformedURLException {
            return new UrlResource(JARFILE_URL_PREFIX + path + "!/");
        }
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<Resource> findMatchingResources(URL rootDirUrl, String locationPattern, PathMatcher pathMatcher) throws IOException {
            Object root = VfsPatternUtils.findRoot(rootDirUrl);
            PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(VfsPatternUtils.getPath(root), locationPattern, pathMatcher);
            VfsPatternUtils.visit(root, visitor);
            return visitor.getResources();
        }
    }

    private static class PatternVirtualFileVisitor
    implements InvocationHandler {
        private final String subPattern;
        private final PathMatcher pathMatcher;
        private final String rootPath;
        private final Set<Resource> resources = new LinkedHashSet<Resource>(64);

        public PatternVirtualFileVisitor(String rootPath, String subPattern, PathMatcher pathMatcher) {
            this.subPattern = subPattern;
            this.pathMatcher = pathMatcher;
            this.rootPath = rootPath.isEmpty() || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (Object.class == method.getDeclaringClass()) {
                switch (methodName) {
                    case "equals": {
                        return proxy == args[0];
                    }
                    case "hashCode": {
                        return System.identityHashCode(proxy);
                    }
                }
            }
            return switch (methodName) {
                case "getAttributes" -> this.getAttributes();
                case "visit" -> {
                    this.visit(args[0]);
                    yield null;
                }
                case "toString" -> this.toString();
                default -> throw new IllegalStateException("Unexpected method invocation: " + String.valueOf(method));
            };
        }

        public void visit(Object vfsResource) {
            if (this.pathMatcher.match(this.subPattern, VfsPatternUtils.getPath(vfsResource).substring(this.rootPath.length()))) {
                this.resources.add(new VfsResource(vfsResource));
            }
        }

        public @Nullable Object getAttributes() {
            return VfsPatternUtils.getVisitorAttributes();
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            return "sub-pattern: " + this.subPattern + ", resources: " + String.valueOf(this.resources);
        }
    }
}

