/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public abstract class SerializationUtils {
    public static byte @Nullable [] serialize(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to serialize object of type: " + String.valueOf(object.getClass()), ex);
        }
        return baos.toByteArray();
    }

    @Deprecated
    public static @Nullable Object deserialize(byte @Nullable [] bytes) {
        Object object;
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed to deserialize object", ex);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Failed to deserialize object type", ex);
            }
        }
        ois.close();
        return object;
    }

    public static <T extends Serializable> T clone(T object) {
        Object result = SerializationUtils.deserialize(SerializationUtils.serialize(object));
        Assert.state(result != null, "Deserialized object must not be null");
        return (T)((Serializable)result);
    }
}

