/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.classfile.AnnotationElement;
import java.lang.classfile.AnnotationValue;
import java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ClassUtils;

abstract class ClassFileAnnotationMetadata {
    ClassFileAnnotationMetadata() {
    }

    static MergedAnnotations createMergedAnnotations(String className, RuntimeVisibleAnnotationsAttribute annotationAttribute, @Nullable ClassLoader classLoader) {
        Set<MergedAnnotation<?>> annotations = annotationAttribute.annotations().stream().map(ann -> ClassFileAnnotationMetadata.createMergedAnnotation(className, ann, classLoader)).filter(Objects::nonNull).collect(Collectors.toSet());
        return MergedAnnotations.of(annotations);
    }

    private static <A extends Annotation> @Nullable MergedAnnotation<A> createMergedAnnotation(String className, java.lang.classfile.Annotation annotation, @Nullable ClassLoader classLoader) {
        String typeName = ClassFileAnnotationMetadata.fromTypeDescriptor(annotation.className().stringValue());
        if (AnnotationFilter.PLAIN.matches(typeName)) {
            return null;
        }
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(4);
        try {
            for (AnnotationElement element : annotation.elements()) {
                Object annotationValue = ClassFileAnnotationMetadata.readAnnotationValue(className, element.value(), classLoader);
                if (annotationValue == null) continue;
                attributes.put(element.name().stringValue(), annotationValue);
            }
            Map compactedAttributes = attributes.isEmpty() ? Collections.emptyMap() : attributes;
            Class<?> annotationType = ClassUtils.forName(typeName, classLoader);
            return MergedAnnotation.of(classLoader, new Source(annotation), annotationType, compactedAttributes);
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return null;
        }
    }

    private static @Nullable Object readAnnotationValue(String className, AnnotationValue elementValue, @Nullable ClassLoader classLoader) {
        AnnotationValue annotationValue = elementValue;
        Objects.requireNonNull(annotationValue);
        AnnotationValue annotationValue2 = annotationValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationValue.OfConstant.class, AnnotationValue.OfAnnotation.class, AnnotationValue.OfClass.class, AnnotationValue.OfEnum.class, AnnotationValue.OfArray.class}, (AnnotationValue)annotationValue2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AnnotationValue.OfConstant constantValue = (AnnotationValue.OfConstant)annotationValue2;
                return constantValue.resolvedValue();
            }
            case 1: {
                AnnotationValue.OfAnnotation annotationValue3 = (AnnotationValue.OfAnnotation)annotationValue2;
                return ClassFileAnnotationMetadata.createMergedAnnotation(className, annotationValue3.annotation(), classLoader);
            }
            case 2: {
                AnnotationValue.OfClass classValue = (AnnotationValue.OfClass)annotationValue2;
                return ClassFileAnnotationMetadata.fromTypeDescriptor(classValue.className().stringValue());
            }
            case 3: {
                AnnotationValue.OfEnum enumValue = (AnnotationValue.OfEnum)annotationValue2;
                return ClassFileAnnotationMetadata.parseEnum(enumValue, classLoader);
            }
            case 4: 
        }
        AnnotationValue.OfArray arrayValue = (AnnotationValue.OfArray)annotationValue2;
        return ClassFileAnnotationMetadata.parseArrayValue(className, classLoader, arrayValue);
    }

    private static String fromTypeDescriptor(String descriptor) {
        ClassDesc classDesc = ClassDesc.ofDescriptor(descriptor);
        return classDesc.isPrimitive() ? classDesc.displayName() : classDesc.packageName() + "." + classDesc.displayName();
    }

    private static Object parseArrayValue(String className, @Nullable ClassLoader classLoader, AnnotationValue.OfArray arrayValue) {
        if (arrayValue.values().isEmpty()) {
            return new Object[0];
        }
        Stream stream = arrayValue.values().stream();
        AnnotationValue annotationValue = (AnnotationValue)arrayValue.values().getFirst();
        Objects.requireNonNull(annotationValue);
        AnnotationValue annotationValue2 = annotationValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationValue.OfInt.class, AnnotationValue.OfDouble.class, AnnotationValue.OfLong.class}, (AnnotationValue)annotationValue2, n)) {
            case 0: {
                return stream.map(AnnotationValue.OfInt.class::cast).mapToInt(AnnotationValue.OfInt::intValue).toArray();
            }
            case 1: {
                return stream.map(AnnotationValue.OfDouble.class::cast).mapToDouble(AnnotationValue.OfDouble::doubleValue).toArray();
            }
            case 2: {
                return stream.map(AnnotationValue.OfLong.class::cast).mapToLong(AnnotationValue.OfLong::longValue).toArray();
            }
        }
        Object firstResolvedValue = ClassFileAnnotationMetadata.readAnnotationValue(className, (AnnotationValue)arrayValue.values().getFirst(), classLoader);
        return stream.map(rawValue -> ClassFileAnnotationMetadata.readAnnotationValue(className, rawValue, classLoader)).toArray(s -> (Object[])Array.newInstance(firstResolvedValue.getClass(), s));
    }

    private static <E extends Enum<E>> @Nullable Enum<E> parseEnum(AnnotationValue.OfEnum enumValue, @Nullable ClassLoader classLoader) {
        String enumClassName = ClassFileAnnotationMetadata.fromTypeDescriptor(enumValue.className().stringValue());
        try {
            Class<?> enumClass = ClassUtils.forName(enumClassName, classLoader);
            return Enum.valueOf(enumClass, enumValue.constantName().stringValue());
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return null;
        }
    }

    record Source(java.lang.classfile.Annotation entryName) {
    }
}

