/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.CompositeMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.UnmodifiableMultiValueMap;

public abstract class CollectionUtils {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable Collection<? extends @Nullable Object> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable Map<?, ? extends @Nullable Object> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(CollectionUtils.computeInitialCapacity(expectedSize), 0.75f);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap(CollectionUtils.computeInitialCapacity(expectedSize), 0.75f);
    }

    public static <E> HashSet<E> newHashSet(int expectedSize) {
        return new HashSet(CollectionUtils.computeInitialCapacity(expectedSize), 0.75f);
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(int expectedSize) {
        return new LinkedHashSet(CollectionUtils.computeInitialCapacity(expectedSize), 0.75f);
    }

    private static int computeInitialCapacity(int expectedSize) {
        return (int)Math.ceil((double)expectedSize / 0.75);
    }

    public static List<?> arrayToList(@Nullable Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static <E> void mergeArrayIntoCollection(@Nullable Object array, Collection<E> collection) {
        Object[] arr = ObjectUtils.toObjectArray(array);
        Collections.addAll(collection, arr);
    }

    public static <K, V> void mergePropertiesIntoMap(@Nullable Properties props, Map<K, V> map) {
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.get(key);
                if (value == null) {
                    value = props.getProperty(key);
                }
                map.put(key, value);
            }
        }
    }

    @Contract(value="null, _ -> false")
    public static boolean contains(@Nullable Iterator<? extends @Nullable Object> iterator, @Nullable Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean contains(@Nullable Enumeration<? extends @Nullable Object> enumeration, @Nullable Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean containsInstance(@Nullable Collection<? extends @Nullable Object> collection, @Nullable Object element) {
        if (collection != null) {
            for (Object object : collection) {
                if (object != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<? extends @Nullable Object> source, Collection<? extends @Nullable Object> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object object : candidates) {
            if (!source.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static <E> @Nullable E findFirstMatch(Collection<?> source, Collection<E> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (E candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    public static <T> @Nullable T findValueOfType(@Nullable Collection<?> collection, @Nullable Class<T> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static @Nullable Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = CollectionUtils.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static @Nullable Class<?> findCommonElementType(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    @Contract(value="null -> null")
    public static <T> @Nullable T firstElement(@Nullable Set<T> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        if (set instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)set;
            return (T)sortedSet.first();
        }
        Iterator<T> it = set.iterator();
        T first = null;
        if (it.hasNext()) {
            first = it.next();
        }
        return first;
    }

    @Contract(value="null -> null")
    public static <T> @Nullable T firstElement(@Nullable List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Contract(value="null -> null")
    public static <T> @Nullable T lastElement(@Nullable Set<T> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        if (set instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)set;
            return (T)sortedSet.last();
        }
        Iterator<T> it = set.iterator();
        T last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    @Contract(value="null -> null")
    public static <T> @Nullable T lastElement(@Nullable List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array);
    }

    public static <E> Iterator<E> toIterator(@Nullable Enumeration<E> enumeration) {
        return enumeration != null ? enumeration.asIterator() : Collections.emptyIterator();
    }

    public static <K, V> MultiValueMap<K, V> toMultiValueMap(Map<K, List<V>> targetMap) {
        return new MultiValueMapAdapter<K, V>(targetMap);
    }

    public static <K, V> MultiValueMap<K, V> unmodifiableMultiValueMap(MultiValueMap<? extends K, ? extends V> targetMap) {
        Assert.notNull(targetMap, "'targetMap' must not be null");
        if (targetMap instanceof UnmodifiableMultiValueMap) {
            return targetMap;
        }
        return new UnmodifiableMultiValueMap<K, V>(targetMap);
    }

    public static <K, V> Map<K, V> compositeMap(Map<K, V> first, Map<K, V> second) {
        return new CompositeMap<K, V>(first, second);
    }

    public static <K, V> Map<K, V> compositeMap(Map<K, V> first, Map<K, V> second, @Nullable BiFunction<K, V, V> putFunction, @Nullable Consumer<Map<K, V>> putAllFunction) {
        return new CompositeMap<K, V>(first, second, putFunction, putAllFunction);
    }
}

