/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.common;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStringExpression
implements Expression {
    private final String expressionString;
    private final Expression[] expressions;

    public CompositeStringExpression(String expressionString, Expression[] expressions) {
        this.expressionString = expressionString;
        this.expressions = expressions;
    }

    @Override
    public final String getExpressionString() {
        return this.expressionString;
    }

    @Override
    public String getValue() throws EvaluationException {
        StringBuilder sb = new StringBuilder();
        Expression[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            sb.append(ObjectUtils.getDisplayString((Object)expression.getValue()));
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String getValue(EvaluationContext context) throws EvaluationException {
        StringBuilder sb = new StringBuilder();
        Expression[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            sb.append(ObjectUtils.getDisplayString((Object)expression.getValue(context)));
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public Class getValueType(EvaluationContext context) {
        return String.class;
    }

    @Override
    public Class getValueType() {
        return String.class;
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor(EvaluationContext context) {
        return TypeDescriptor.valueOf(String.class);
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor() {
        return TypeDescriptor.valueOf(String.class);
    }

    @Override
    public void setValue(EvaluationContext context, Object value) throws EvaluationException {
        throw new EvaluationException(this.expressionString, "Cannot call setValue on a composite expression");
    }

    @Override
    public <T> T getValue(EvaluationContext context, Class<T> expectedResultType) throws EvaluationException {
        String value = this.getValue(context);
        return ExpressionUtils.convert(context, value, expectedResultType);
    }

    @Override
    public <T> T getValue(Class<T> expectedResultType) throws EvaluationException {
        String value = this.getValue();
        return ExpressionUtils.convert(null, value, expectedResultType);
    }

    @Override
    public boolean isWritable(EvaluationContext context) {
        return false;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }
}

