/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.List;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorReference
extends SpelNodeImpl {
    private volatile ConstructorExecutor cachedExecutor;

    public ConstructorReference(int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.createNewInstance(state);
    }

    private TypedValue createNewInstance(ExpressionState state) throws EvaluationException {
        Object[] arguments = new Object[this.getChildCount() - 1];
        Class[] argumentTypes = new Class[this.getChildCount() - 1];
        int i = 0;
        while (i < arguments.length) {
            Object value;
            TypedValue childValue = this.children[i + 1].getValueInternal(state);
            arguments[i] = value = childValue.getValue();
            argumentTypes[i] = value == null ? null : value.getClass();
            ++i;
        }
        ConstructorExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state.getEvaluationContext(), arguments);
            }
            catch (AccessException accessException) {
                this.cachedExecutor = null;
            }
        }
        String typename = (String)this.children[0].getValueInternal(state).getValue();
        executorToUse = this.findExecutorForConstructor(typename, argumentTypes, state);
        try {
            this.cachedExecutor = executorToUse;
            TypedValue result = executorToUse.execute(state.getEvaluationContext(), arguments);
            return result;
        }
        catch (AccessException ae) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
        }
    }

    private ConstructorExecutor findExecutorForConstructor(String typename, Class<?>[] argumentTypes, ExpressionState state) throws SpelEvaluationException {
        EvaluationContext eContext = state.getEvaluationContext();
        List<ConstructorResolver> cResolvers = eContext.getConstructorResolvers();
        if (cResolvers != null) {
            for (ConstructorResolver ctorResolver : cResolvers) {
                try {
                    ConstructorExecutor cEx = ctorResolver.resolve(state.getEvaluationContext(), typename, argumentTypes);
                    if (cEx == null) continue;
                    return cEx;
                }
                catch (AccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, typename, FormatHelper.formatMethodForMessage("", argumentTypes));
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        int index = 0;
        sb.append(this.getChild(index++).toStringAST());
        sb.append("(");
        int i = index;
        while (i < this.getChildCount()) {
            if (i > index) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

