/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class OpMinus
extends Operator {
    public OpMinus(int pos, SpelNodeImpl ... operands) {
        super("-", pos, operands);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        if (rightOp == null) {
            Object operand = leftOp.getValueInternal(state).getValue();
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (operand instanceof Double) {
                    return new TypedValue(0.0 - n.doubleValue());
                }
                if (operand instanceof Float) {
                    return new TypedValue(Float.valueOf(0.0f - n.floatValue()));
                }
                if (operand instanceof Long) {
                    return new TypedValue(0L - n.longValue());
                }
                return new TypedValue(0 - n.intValue());
            }
            return state.operate(Operation.SUBTRACT, operand, null);
        }
        Object left = leftOp.getValueInternal(state).getValue();
        Object right = rightOp.getValueInternal(state).getValue();
        if (left instanceof Number && right instanceof Number) {
            Number op1 = (Number)left;
            Number op2 = (Number)right;
            if (op1 instanceof Double || op2 instanceof Double) {
                return new TypedValue(op1.doubleValue() - op2.doubleValue());
            }
            if (op1 instanceof Float || op2 instanceof Float) {
                return new TypedValue(Float.valueOf(op1.floatValue() - op2.floatValue()));
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return new TypedValue(op1.longValue() - op2.longValue());
            }
            return new TypedValue(op1.intValue() - op2.intValue());
        }
        if (left instanceof String && right instanceof Integer && ((String)left).length() == 1) {
            String theString = (String)left;
            Integer theInteger = (Integer)right;
            return new TypedValue(Character.toString((char)(theString.charAt(0) - theInteger)));
        }
        return state.operate(Operation.SUBTRACT, left, right);
    }

    @Override
    public String toStringAST() {
        if (this.getRightOperand() == null) {
            return "-" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    @Override
    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            return null;
        }
        return this.children[1];
    }
}

