/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpNE
extends Operator {
    public OpNE(int pos, SpelNodeImpl ... operands) {
        super("!=", pos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object left = this.getLeftOperand().getValueInternal(state).getValue();
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        if (left instanceof Number && right instanceof Number) {
            Number op1 = (Number)left;
            Number op2 = (Number)right;
            if (op1 instanceof Double || op2 instanceof Double) {
                return BooleanTypedValue.forValue(op1.doubleValue() != op2.doubleValue());
            }
            if (op1 instanceof Float || op2 instanceof Float) {
                return BooleanTypedValue.forValue(op1.floatValue() != op2.floatValue());
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return BooleanTypedValue.forValue(op1.longValue() != op2.longValue());
            }
            return BooleanTypedValue.forValue(op1.intValue() != op2.intValue());
        }
        if (left != null && left instanceof Comparable) {
            return BooleanTypedValue.forValue(state.getTypeComparator().compare(left, right) != 0);
        }
        return BooleanTypedValue.forValue(left != right);
    }
}

