/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class Elvis
extends SpelNodeImpl {
    public Elvis(int pos, SpelNodeImpl ... args) {
        super(pos, args);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue value = this.children[0].getValueInternal(state);
        if (!(value.getValue() == null || value.getValue() instanceof String && ((String)value.getValue()).length() == 0)) {
            return value;
        }
        TypedValue result = this.children[1].getValueInternal(state);
        if (this.exitTypeDescriptor == null) {
            String testDescriptor = this.children[0].exitTypeDescriptor;
            String ifNullDescriptor = this.children[1].exitTypeDescriptor;
            this.exitTypeDescriptor = testDescriptor.equals(ifNullDescriptor) ? testDescriptor : "Ljava/lang/Object";
        }
        return result;
    }

    @Override
    public String toStringAST() {
        return this.getChild(0).toStringAST() + " ?: " + this.getChild(1).toStringAST();
    }

    private void computeExitTypeDescriptor() {
        if (this.exitTypeDescriptor == null && this.children[0].getExitDescriptor() != null && this.children[1].getExitDescriptor() != null) {
            String conditionDescriptor = this.children[0].exitTypeDescriptor;
            String ifNullValueDescriptor = this.children[1].exitTypeDescriptor;
            this.exitTypeDescriptor = conditionDescriptor.equals(ifNullValueDescriptor) ? conditionDescriptor : (conditionDescriptor.equals("Ljava/lang/Object") && !CodeFlow.isPrimitive(ifNullValueDescriptor) ? ifNullValueDescriptor : (ifNullValueDescriptor.equals("Ljava/lang/Object") && !CodeFlow.isPrimitive(conditionDescriptor) ? conditionDescriptor : "Ljava/lang/Object"));
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl condition = this.children[0];
        SpelNodeImpl ifNullValue = this.children[1];
        if (!condition.isCompilable() || !ifNullValue.isCompilable()) {
            return false;
        }
        return condition.getExitDescriptor() != null && ifNullValue.getExitDescriptor() != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        this.computeExitTypeDescriptor();
        this.children[0].generateCode(mv, codeflow);
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        mv.visitInsn(89);
        mv.visitJumpInsn(198, elseTarget);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        mv.visitInsn(87);
        this.children[1].generateCode(mv, codeflow);
        if (!CodeFlow.isPrimitive(this.getExitDescriptor())) {
            CodeFlow.insertBoxIfNecessary(mv, codeflow.lastDescriptor().charAt(0));
        }
        mv.visitLabel(endOfIf);
        codeflow.pushDescriptor(this.getExitDescriptor());
    }
}

