/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpOr
extends Operator {
    public OpOr(int pos, SpelNodeImpl ... operands) {
        super("or", pos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.getBooleanValue(state, this.getLeftOperand())) {
            return BooleanTypedValue.TRUE;
        }
        return BooleanTypedValue.forValue(this.getBooleanValue(state, this.getRightOperand()));
    }

    private boolean getBooleanValue(ExpressionState state, SpelNodeImpl operand) {
        try {
            Boolean value = operand.getValue(state, Boolean.class);
            this.assertValueNotNull(value);
            return value;
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(operand.getStartPosition());
            throw ee;
        }
    }

    private void assertValueNotNull(Boolean value) {
        if (value == null) {
            throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl left = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        if (!left.isCompilable() || !right.isCompilable()) {
            return false;
        }
        return CodeFlow.isBooleanCompatible(left.getExitDescriptor()) && CodeFlow.isBooleanCompatible(right.getExitDescriptor());
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        codeflow.enterCompilationScope();
        this.getLeftOperand().generateCode(mv, codeflow);
        codeflow.unboxBooleanIfNecessary(mv);
        codeflow.exitCompilationScope();
        mv.visitJumpInsn(153, elseTarget);
        mv.visitLdcInsn((Object)1);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        codeflow.enterCompilationScope();
        this.getRightOperand().generateCode(mv, codeflow);
        codeflow.unboxBooleanIfNecessary(mv);
        codeflow.exitCompilationScope();
        mv.visitLabel(endOfIf);
        codeflow.pushDescriptor(this.getExitDescriptor());
    }
}

