/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.CannotReadScriptException;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDatabasePopulator
implements DatabasePopulator {
    private static final Log logger = LogFactory.getLog(ResourceDatabasePopulator.class);
    private List<Resource> scripts = new ArrayList<Resource>();
    private String sqlScriptEncoding;
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;
    private static String COMMENT_PREFIX = "--";

    public void addScript(Resource script) {
        this.scripts.add(script);
    }

    public void setScripts(Resource[] scripts) {
        this.scripts = Arrays.asList(scripts);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(Connection connection) throws SQLException {
        for (Resource script : this.scripts) {
            this.executeSqlScript(connection, this.applyEncodingIfNecessary(script), this.continueOnError, this.ignoreFailedDrops);
        }
    }

    private EncodedResource applyEncodingIfNecessary(Resource script) {
        if (script instanceof EncodedResource) {
            return (EncodedResource)script;
        }
        return new EncodedResource(script, this.sqlScriptEncoding);
    }

    private void executeSqlScript(Connection connection, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops) throws SQLException {
        String script;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing SQL script from " + resource));
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        try {
            script = ResourceDatabasePopulator.readScript(resource);
        }
        catch (IOException e) {
            throw new CannotReadScriptException(resource, (Throwable)e);
        }
        char delimiter = ';';
        if (!ResourceDatabasePopulator.containsSqlScriptDelimiters(script, delimiter)) {
            delimiter = '\n';
        }
        ResourceDatabasePopulator.splitSqlScript(script, delimiter, statements);
        int lineNumber = 0;
        Statement stmt = connection.createStatement();
        try {
            for (String statement : statements) {
                ++lineNumber;
                try {
                    int rowsAffected = stmt.executeUpdate(statement);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(String.valueOf(rowsAffected) + " rows affected by SQL: " + statement));
                }
                catch (SQLException ex) {
                    boolean dropStatement = statement.trim().toLowerCase().startsWith("drop");
                    if (continueOnError || dropStatement && ignoreFailedDrops) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Line " + lineNumber + " statement failed: " + statement), (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not close JDBC Statement", ex);
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Done executing SQL script from " + resource + " in " + elapsedTime + " ms."));
        }
    }

    private static String readScript(EncodedResource resource) throws IOException {
        LineNumberReader lnr = new LineNumberReader(resource.getReader());
        String currentStatement = lnr.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (StringUtils.hasText((String)currentStatement) && !currentStatement.startsWith(COMMENT_PREFIX)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lnr.readLine();
        }
        return scriptBuilder.toString();
    }

    private static boolean containsSqlScriptDelimiters(String script, char delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i = 0;
        while (i < script.length()) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i] == delim && !inLiteral) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void splitSqlScript(String script, char delim, List<String> statements) {
        StringBuilder sb = new StringBuilder();
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i = 0;
        while (i < script.length()) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i] == delim && !inLiteral) {
                if (sb.length() > 0) {
                    statements.add(sb.toString());
                    sb = new StringBuilder();
                }
            } else {
                sb.append(content[i]);
            }
            ++i;
        }
        if (sb.length() > 0) {
            statements.add(sb.toString());
        }
    }
}

