/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;
import org.springframework.util.ReflectionUtils;

public class OracleTableMetaDataProvider
extends GenericTableMetaDataProvider {
    private final boolean includeSynonyms;
    private String defaultSchema;

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this(databaseMetaData, false);
    }

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData, boolean includeSynonyms) throws SQLException {
        super(databaseMetaData);
        this.includeSynonyms = includeSynonyms;
        this.lookupDefaultSchema(databaseMetaData);
    }

    private void lookupDefaultSchema(DatabaseMetaData databaseMetaData) {
        try (CallableStatement cstmt = null;){
            cstmt = databaseMetaData.getConnection().prepareCall("{? = call sys_context('USERENV', 'CURRENT_SCHEMA')}");
            cstmt.registerOutParameter(1, 12);
            cstmt.execute();
            this.defaultSchema = cstmt.getString(1);
        }
        catch (SQLException ex) {
            logger.debug((Object)"Encountered exception during default schema lookup", (Throwable)ex);
        }
    }

    @Override
    protected String getDefaultSchema() {
        if (this.defaultSchema != null) {
            return this.defaultSchema;
        }
        return super.getDefaultSchema();
    }

    @Override
    public void initializeWithTableColumnMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) throws SQLException {
        Method setIncludeSynonyms;
        Boolean originalValueForIncludeSynonyms;
        if (!this.includeSynonyms) {
            logger.debug((Object)"Defaulting to no synonyms in table metadata lookup");
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        Connection con = databaseMetaData.getConnection();
        try {
            Class<?> oracleConClass = con.getClass().getClassLoader().loadClass("oracle.jdbc.OracleConnection");
            con = (Connection)con.unwrap(oracleConClass);
        }
        catch (ClassNotFoundException | SQLException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Unable to include synonyms in table metadata lookup - no Oracle Connection: " + ex));
            }
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        logger.debug((Object)"Including synonyms in table metadata lookup");
        try {
            Method getIncludeSynonyms = con.getClass().getMethod("getIncludeSynonyms", null);
            ReflectionUtils.makeAccessible((Method)getIncludeSynonyms);
            originalValueForIncludeSynonyms = (Boolean)getIncludeSynonyms.invoke((Object)con, new Object[0]);
            setIncludeSynonyms = con.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
            ReflectionUtils.makeAccessible((Method)setIncludeSynonyms);
            setIncludeSynonyms.invoke((Object)con, Boolean.TRUE);
        }
        catch (Throwable ex) {
            throw new InvalidDataAccessApiUsageException("Could not prepare Oracle Connection", ex);
        }
        super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
        try {
            setIncludeSynonyms.invoke((Object)con, originalValueForIncludeSynonyms);
        }
        catch (Throwable ex) {
            throw new InvalidDataAccessApiUsageException("Could not reset Oracle Connection", ex);
        }
    }
}

