/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractFallbackSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SQLExceptionTranslator fallbackTranslator;

    public void setFallbackTranslator(SQLExceptionTranslator fallback) {
        this.fallbackTranslator = fallback;
    }

    @Nullable
    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    @Override
    public DataAccessException translate(@Nullable String task, @Nullable String sql, SQLException ex) {
        DataAccessException dex;
        Assert.notNull((Object)ex, (String)"Cannot translate a null SQLException");
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if ((dex = this.doTranslate(task, sql, ex)) != null) {
            return dex;
        }
        SQLExceptionTranslator fallback = this.getFallbackTranslator();
        if (fallback != null) {
            return fallback.translate(task, sql, ex);
        }
        return new UncategorizedSQLException(task, sql, ex);
    }

    @Nullable
    protected abstract DataAccessException doTranslate(String var1, String var2, SQLException var3);

    protected String buildMessage(String task, String sql, SQLException ex) {
        return task + "; SQL [" + sql + "]; " + ex.getMessage();
    }
}

