/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.SqlInOutParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.metadata.CallMetaDataProvider;
import org.springframework.jdbc.core.metadata.CallParameterMetaData;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class GenericCallMetaDataProvider
implements CallMetaDataProvider {
    protected static final Log logger = LogFactory.getLog(CallMetaDataProvider.class);
    private boolean procedureColumnMetaDataUsed = false;
    private String userName;
    private boolean supportsCatalogsInProcedureCalls = true;
    private boolean supportsSchemasInProcedureCalls = true;
    private boolean storesUpperCaseIdentifiers = true;
    private boolean storesLowerCaseIdentifiers = false;
    private List<CallParameterMetaData> callParameterMetaData = new ArrayList<CallParameterMetaData>();

    protected GenericCallMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this.userName = databaseMetaData.getUserName();
    }

    @Override
    public void initializeWithMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        block11: {
            block10: {
                block9: {
                    block8: {
                        try {
                            this.setSupportsCatalogsInProcedureCalls(databaseMetaData.supportsCatalogsInProcedureCalls());
                        }
                        catch (SQLException ex) {
                            if (!logger.isWarnEnabled()) break block8;
                            logger.warn((Object)("Error retrieving 'DatabaseMetaData.supportsCatalogsInProcedureCalls': " + ex.getMessage()));
                        }
                    }
                    try {
                        this.setSupportsSchemasInProcedureCalls(databaseMetaData.supportsSchemasInProcedureCalls());
                    }
                    catch (SQLException ex) {
                        if (!logger.isWarnEnabled()) break block9;
                        logger.warn((Object)("Error retrieving 'DatabaseMetaData.supportsSchemasInProcedureCalls': " + ex.getMessage()));
                    }
                }
                try {
                    this.setStoresUpperCaseIdentifiers(databaseMetaData.storesUpperCaseIdentifiers());
                }
                catch (SQLException ex) {
                    if (!logger.isWarnEnabled()) break block10;
                    logger.warn((Object)("Error retrieving 'DatabaseMetaData.storesUpperCaseIdentifiers': " + ex.getMessage()));
                }
            }
            try {
                this.setStoresLowerCaseIdentifiers(databaseMetaData.storesLowerCaseIdentifiers());
            }
            catch (SQLException ex) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn((Object)("Error retrieving 'DatabaseMetaData.storesLowerCaseIdentifiers': " + ex.getMessage()));
            }
        }
    }

    @Override
    public void initializeWithProcedureColumnMetaData(DatabaseMetaData databaseMetaData, @Nullable String catalogName, @Nullable String schemaName, @Nullable String procedureName) throws SQLException {
        this.procedureColumnMetaDataUsed = true;
        this.processProcedureColumns(databaseMetaData, catalogName, schemaName, procedureName);
    }

    @Override
    public List<CallParameterMetaData> getCallParameterMetaData() {
        return this.callParameterMetaData;
    }

    @Override
    public String procedureNameToUse(@Nullable String procedureName) {
        if (procedureName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return procedureName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return procedureName.toLowerCase();
        }
        return procedureName;
    }

    @Override
    public String catalogNameToUse(@Nullable String catalogName) {
        if (catalogName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return catalogName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return catalogName.toLowerCase();
        }
        return catalogName;
    }

    @Override
    public String schemaNameToUse(@Nullable String schemaName) {
        if (schemaName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return schemaName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return schemaName.toLowerCase();
        }
        return schemaName;
    }

    @Override
    public String metaDataCatalogNameToUse(@Nullable String catalogName) {
        if (this.isSupportsCatalogsInProcedureCalls()) {
            return this.catalogNameToUse(catalogName);
        }
        return null;
    }

    @Override
    public String metaDataSchemaNameToUse(@Nullable String schemaName) {
        if (this.isSupportsSchemasInProcedureCalls()) {
            return this.schemaNameToUse(schemaName);
        }
        return null;
    }

    @Override
    public String parameterNameToUse(@Nullable String parameterName) {
        if (parameterName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return parameterName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return parameterName.toLowerCase();
        }
        return parameterName;
    }

    @Override
    public boolean byPassReturnParameter(String parameterName) {
        return false;
    }

    @Override
    public SqlParameter createDefaultOutParameter(String parameterName, CallParameterMetaData meta) {
        return new SqlOutParameter(parameterName, meta.getSqlType());
    }

    @Override
    public SqlParameter createDefaultInOutParameter(String parameterName, CallParameterMetaData meta) {
        return new SqlInOutParameter(parameterName, meta.getSqlType());
    }

    @Override
    public SqlParameter createDefaultInParameter(String parameterName, CallParameterMetaData meta) {
        return new SqlParameter(parameterName, meta.getSqlType());
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isReturnResultSetSupported() {
        return true;
    }

    @Override
    public boolean isRefCursorSupported() {
        return false;
    }

    @Override
    public int getRefCursorSqlType() {
        return 1111;
    }

    @Override
    public boolean isProcedureColumnMetaDataUsed() {
        return this.procedureColumnMetaDataUsed;
    }

    protected void setSupportsCatalogsInProcedureCalls(boolean supportsCatalogsInProcedureCalls) {
        this.supportsCatalogsInProcedureCalls = supportsCatalogsInProcedureCalls;
    }

    @Override
    public boolean isSupportsCatalogsInProcedureCalls() {
        return this.supportsCatalogsInProcedureCalls;
    }

    protected void setSupportsSchemasInProcedureCalls(boolean supportsSchemasInProcedureCalls) {
        this.supportsSchemasInProcedureCalls = supportsSchemasInProcedureCalls;
    }

    @Override
    public boolean isSupportsSchemasInProcedureCalls() {
        return this.supportsSchemasInProcedureCalls;
    }

    protected void setStoresUpperCaseIdentifiers(boolean storesUpperCaseIdentifiers) {
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
    }

    protected boolean isStoresUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    protected void setStoresLowerCaseIdentifiers(boolean storesLowerCaseIdentifiers) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
    }

    protected boolean isStoresLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProcedureColumns(DatabaseMetaData databaseMetaData, @Nullable String catalogName, @Nullable String schemaName, @Nullable String procedureName) {
        String metaDataCatalogName = this.metaDataCatalogNameToUse(catalogName);
        String metaDataSchemaName = this.metaDataSchemaNameToUse(schemaName);
        String metaDataProcedureName = this.procedureNameToUse(procedureName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving metadata for " + metaDataCatalogName + '/' + metaDataSchemaName + '/' + metaDataProcedureName));
        }
        ResultSet procs = null;
        try {
            procs = databaseMetaData.getProcedures(metaDataCatalogName, metaDataSchemaName, metaDataProcedureName);
            ArrayList<String> found = new ArrayList<String>();
            while (procs.next()) {
                found.add(procs.getString("PROCEDURE_CAT") + '.' + procs.getString("PROCEDURE_SCHEM") + '.' + procs.getString("PROCEDURE_NAME"));
            }
            procs.close();
            if (found.size() > 1) {
                throw new InvalidDataAccessApiUsageException("Unable to determine the correct call signature - multiple procedures/functions/signatures for '" + metaDataProcedureName + "': found " + found);
            }
            if (found.isEmpty()) {
                if (metaDataProcedureName != null && metaDataProcedureName.contains(".") && !StringUtils.hasText((String)metaDataCatalogName)) {
                    String packageName = metaDataProcedureName.substring(0, metaDataProcedureName.indexOf("."));
                    throw new InvalidDataAccessApiUsageException("Unable to determine the correct call signature for '" + metaDataProcedureName + "' - package name should be specified separately using '.withCatalogName(\"" + packageName + "\")'");
                }
                throw new InvalidDataAccessApiUsageException("Unable to determine the correct call signature - no procedure/function/signature for '" + metaDataProcedureName + "'");
            }
            procs = databaseMetaData.getProcedureColumns(metaDataCatalogName, metaDataSchemaName, metaDataProcedureName, null);
            while (procs.next()) {
                String columnName = procs.getString("COLUMN_NAME");
                int columnType = procs.getInt("COLUMN_TYPE");
                if (columnName == null && (columnType == 1 || columnType == 2 || columnType == 4)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Skipping metadata for: " + columnType + " " + procs.getInt("DATA_TYPE") + " " + procs.getString("TYPE_NAME") + " " + procs.getInt("NULLABLE") + " (probably a member of a collection)"));
                    continue;
                }
                CallParameterMetaData meta = new CallParameterMetaData(columnName, columnType, procs.getInt("DATA_TYPE"), procs.getString("TYPE_NAME"), procs.getInt("NULLABLE") == 1);
                this.callParameterMetaData.add(meta);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Retrieved metadata: " + meta.getParameterName() + " " + meta.getParameterType() + " " + meta.getSqlType() + " " + meta.getTypeName() + " " + meta.isNullable()));
            }
        }
        catch (SQLException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Error while retrieving metadata for procedure columns: " + ex));
            }
        }
        finally {
            block21: {
                try {
                    if (procs != null) {
                        procs.close();
                    }
                }
                catch (SQLException ex) {
                    if (!logger.isWarnEnabled()) break block21;
                    logger.warn((Object)("Problem closing ResultSet for procedure column metadata: " + ex));
                }
            }
        }
    }
}

