/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.connection.ChainedExceptionListener;
import org.springframework.util.Assert;

public class SingleConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ExceptionListener,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory targetConnectionFactory;
    private String clientId;
    private ExceptionListener exceptionListener;
    private boolean reconnectOnException = false;
    private Connection target;
    private Connection connection;
    private Boolean pubSubMode;
    private boolean started = false;
    private final Object connectionMonitor = new Object();

    public SingleConnectionFactory() {
    }

    public SingleConnectionFactory(Connection target) {
        Assert.notNull((Object)target, (String)"Target Connection must not be null");
        this.target = target;
        this.connection = this.getSharedConnectionProxy(target);
    }

    public SingleConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, (String)"Target ConnectionFactory must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    protected String getClientId() {
        return this.clientId;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    protected boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void afterPropertiesSet() {
        if (this.connection == null && this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("Connection or 'targetConnectionFactory' is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.initConnection();
            }
            return this.connection;
        }
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueConnection createQueueConnection() throws JMSException {
        Connection con = null;
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.pubSubMode = Boolean.FALSE;
            con = this.createConnection();
        }
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("This SingleConnectionFactory does not hold a QueueConnection but rather: " + con);
        }
        return (QueueConnection)con;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicConnection createTopicConnection() throws JMSException {
        Connection con = null;
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.pubSubMode = Boolean.TRUE;
            con = this.createConnection();
        }
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("This SingleConnectionFactory does not hold a TopicConnection but rather: " + con);
        }
        return (TopicConnection)con;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() throws JMSException {
        if (this.getTargetConnectionFactory() == null) {
            throw new java.lang.IllegalStateException("'targetConnectionFactory' is required for lazily initializing a Connection");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.target != null) {
                this.closeConnection(this.target);
            }
            this.target = this.doCreateConnection();
            this.prepareConnection(this.target);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Established shared JMS Connection: " + this.target));
            }
            this.connection = this.getSharedConnectionProxy(this.target);
        }
    }

    public void onException(JMSException ex) {
        this.resetConnection();
    }

    public void destroy() {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.target != null) {
                this.closeConnection(this.target);
            }
            this.target = null;
            this.connection = null;
        }
    }

    protected Connection doCreateConnection() throws JMSException {
        ConnectionFactory cf = this.getTargetConnectionFactory();
        if (Boolean.FALSE.equals(this.pubSubMode) && cf instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)cf).createQueueConnection();
        }
        if (Boolean.TRUE.equals(this.pubSubMode) && cf instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)cf).createTopicConnection();
        }
        return this.getTargetConnectionFactory().createConnection();
    }

    protected void prepareConnection(Connection con) throws JMSException {
        if (this.getClientId() != null) {
            con.setClientID(this.getClientId());
        }
        if (this.getExceptionListener() != null || this.isReconnectOnException()) {
            ExceptionListener listenerToUse = this.getExceptionListener();
            if (this.isReconnectOnException()) {
                listenerToUse = new InternalChainedExceptionListener(this, listenerToUse);
            }
            con.setExceptionListener(listenerToUse);
        }
    }

    protected Session getSession(Connection con, Integer mode) throws JMSException {
        return null;
    }

    protected Session createSession(Connection con, Integer mode) throws JMSException {
        int ackMode;
        boolean transacted = mode == 0;
        int n = ackMode = transacted ? 1 : mode;
        if (Boolean.FALSE.equals(this.pubSubMode) && con instanceof QueueConnection) {
            return ((QueueConnection)con).createQueueSession(transacted, ackMode);
        }
        if (Boolean.TRUE.equals(this.pubSubMode) && con instanceof TopicConnection) {
            return ((TopicConnection)con).createTopicSession(transacted, ackMode);
        }
        return con.createSession(transacted, ackMode);
    }

    protected void closeConnection(Connection con) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing shared JMS Connection: " + this.target));
        }
        try {
            try {
                if (this.started) {
                    this.started = false;
                    con.stop();
                }
            }
            finally {
                con.close();
            }
        }
        catch (IllegalStateException ex) {
            this.logger.debug((Object)("Ignoring Connection state exception - assuming already closed: " + (Object)((Object)ex)));
        }
        catch (Throwable ex) {
            this.logger.debug((Object)"Could not close shared JMS Connection", ex);
        }
    }

    protected Connection getSharedConnectionProxy(Connection target) {
        ArrayList<Class<TopicConnection>> classes = new ArrayList<Class<TopicConnection>>(3);
        classes.add(Connection.class);
        if (target instanceof QueueConnection) {
            classes.add(QueueConnection.class);
        }
        if (target instanceof TopicConnection) {
            classes.add(TopicConnection.class);
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new SharedConnectionInvocationHandler(target));
    }

    private static class InternalChainedExceptionListener
    extends ChainedExceptionListener {
        private ExceptionListener userListener;

        public InternalChainedExceptionListener(ExceptionListener internalListener, ExceptionListener userListener) {
            this.addDelegate(internalListener);
            if (userListener != null) {
                this.addDelegate(userListener);
                this.userListener = userListener;
            }
        }

        public ExceptionListener getUserListener() {
            return this.userListener;
        }
    }

    private class SharedConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public SharedConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                if (proxy == args[0]) {
                    return true;
                }
                return false;
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("toString")) {
                return "Shared JMS Connection: " + this.target;
            }
            if (method.getName().equals("setClientID")) {
                String currentClientId = this.target.getClientID();
                if (currentClientId != null && currentClientId.equals(args[0])) {
                    return null;
                }
                throw new IllegalStateException("setClientID call not supported on proxy for shared Connection. Set the 'clientId' property on the SingleConnectionFactory instead.");
            }
            if (method.getName().equals("setExceptionListener")) {
                ExceptionListener currentExceptionListener = this.target.getExceptionListener();
                if (currentExceptionListener instanceof InternalChainedExceptionListener && args[0] != null) {
                    ((InternalChainedExceptionListener)currentExceptionListener).addDelegate((ExceptionListener)args[0]);
                    return null;
                }
                throw new IllegalStateException("setExceptionListener call not supported on proxy for shared Connection. Set the 'exceptionListener' property on the SingleConnectionFactory instead. Alternatively, activate SingleConnectionFactory's 'reconnectOnException' feature, which will allow for registering further ExceptionListeners to the recovery chain.");
            }
            if (method.getName().equals("start")) {
                this.target.start();
                Object currentExceptionListener = SingleConnectionFactory.this.connectionMonitor;
                synchronized (currentExceptionListener) {
                    SingleConnectionFactory.this.started = true;
                }
                return null;
            }
            if (method.getName().equals("stop")) {
                return null;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            if (method.getName().equals("createSession") || method.getName().equals("createQueueSession") || method.getName().equals("createTopicSession")) {
                boolean transacted = (Boolean)args[0];
                Integer ackMode = (Integer)args[1];
                Integer mode = transacted ? 0 : ackMode;
                Session session = SingleConnectionFactory.this.getSession(this.target, mode);
                if (session != null) {
                    if (!method.getReturnType().isInstance(session)) {
                        String msg = "JMS Session does not implement specific domain: " + session;
                        try {
                            session.close();
                        }
                        catch (Throwable ex) {
                            SingleConnectionFactory.this.logger.trace((Object)"Failed to close newly obtained JMS Session", ex);
                        }
                        throw new IllegalStateException(msg);
                    }
                    return session;
                }
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (method.getName().equals("getExceptionListener") && retVal instanceof InternalChainedExceptionListener) {
                    InternalChainedExceptionListener listener = (InternalChainedExceptionListener)retVal;
                    return listener.getUserListener();
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

