/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.connection.SmartConnectionFactory;
import org.springframework.util.Assert;

public class DelegatingConnectionFactory
implements SmartConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
InitializingBean {
    private ConnectionFactory targetConnectionFactory;
    private boolean shouldStopConnections = false;

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, (String)"'targetConnectionFactory' must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setShouldStopConnections(boolean shouldStopConnections) {
        this.shouldStopConnections = shouldStopConnections;
    }

    public void afterPropertiesSet() {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("'targetConnectionFactory' is required");
        }
    }

    public Connection createConnection() throws JMSException {
        return this.getTargetConnectionFactory().createConnection();
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.getTargetConnectionFactory().createConnection(username, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        ConnectionFactory cf = this.getTargetConnectionFactory();
        if (cf instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)cf).createQueueConnection();
        }
        Connection con = cf.createConnection();
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a QueueConnectionFactory");
        }
        return (QueueConnection)con;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        ConnectionFactory cf = this.getTargetConnectionFactory();
        if (cf instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)cf).createQueueConnection(username, password);
        }
        Connection con = cf.createConnection(username, password);
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a QueueConnectionFactory");
        }
        return (QueueConnection)con;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        ConnectionFactory cf = this.getTargetConnectionFactory();
        if (cf instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)cf).createTopicConnection();
        }
        Connection con = cf.createConnection();
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a TopicConnectionFactory");
        }
        return (TopicConnection)con;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        ConnectionFactory cf = this.getTargetConnectionFactory();
        if (cf instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)cf).createTopicConnection(username, password);
        }
        Connection con = cf.createConnection(username, password);
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a TopicConnectionFactory");
        }
        return (TopicConnection)con;
    }

    public boolean shouldStop(Connection con) {
        return this.shouldStopConnections;
    }
}

