/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TransactionRolledBackException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.connection.TransactionAwareConnectionFactoryProxy;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JmsTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private ConnectionFactory connectionFactory;

    public JmsTransactionManager() {
        this.setTransactionSynchronization(2);
    }

    public JmsTransactionManager(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(ConnectionFactory cf) {
        this.connectionFactory = cf instanceof TransactionAwareConnectionFactoryProxy ? ((TransactionAwareConnectionFactoryProxy)cf).getTargetConnectionFactory() : cf;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
    }

    public Object getResourceFactory() {
        return this.getConnectionFactory();
    }

    protected Object doGetTransaction() {
        JmsTransactionObject txObject = new JmsTransactionObject();
        txObject.setResourceHolder((JmsResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory())));
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        return txObject.getResourceHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("JMS does not support an isolation level concept");
        }
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        Connection con = null;
        Session session = null;
        try {
            con = this.createConnection();
            session = this.createSession(con);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created JMS transaction on Session [" + session + "] from Connection [" + con + "]"));
            }
            txObject.setResourceHolder(new JmsResourceHolder(this.getConnectionFactory(), con, session));
            txObject.getResourceHolder().setSynchronizedWithTransaction(true);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getResourceHolder().setTimeoutInSeconds(timeout);
            }
            TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)txObject.getResourceHolder()));
        }
        catch (Throwable ex) {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            throw new CannotCreateTransactionException("Could not create JMS transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        txObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        JmsResourceHolder conHolder = (JmsResourceHolder)((Object)suspendedResources);
        TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)conHolder));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JmsTransactionObject txObject = (JmsTransactionObject)status.getTransaction();
        Session session = txObject.getResourceHolder().getSession();
        try {
            if (status.isDebug()) {
                this.logger.debug((Object)("Committing JMS transaction on Session [" + session + "]"));
            }
            session.commit();
        }
        catch (TransactionRolledBackException ex) {
            throw new UnexpectedRollbackException("JMS transaction rolled back", (Throwable)ex);
        }
        catch (JMSException ex) {
            throw new TransactionSystemException("Could not commit JMS transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JmsTransactionObject txObject = (JmsTransactionObject)status.getTransaction();
        Session session = txObject.getResourceHolder().getSession();
        try {
            if (status.isDebug()) {
                this.logger.debug((Object)("Rolling back JMS transaction on Session [" + session + "]"));
            }
            session.rollback();
        }
        catch (JMSException ex) {
            throw new TransactionSystemException("Could not roll back JMS transaction", (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JmsTransactionObject txObject = (JmsTransactionObject)status.getTransaction();
        txObject.getResourceHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JmsTransactionObject txObject = (JmsTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
        txObject.getResourceHolder().closeAll();
        txObject.getResourceHolder().clear();
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        return con.createSession(true, 1);
    }

    private static class JmsTransactionObject
    implements SmartTransactionObject {
        private JmsResourceHolder resourceHolder;

        private JmsTransactionObject() {
        }

        public void setResourceHolder(JmsResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        public JmsResourceHolder getResourceHolder() {
            return this.resourceHolder;
        }

        public boolean isRollbackOnly() {
            return this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
        }
    }
}

