/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueRequestor;
import jakarta.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.IllegalStateException;
import org.springframework.jms.InvalidClientIDException;
import org.springframework.jms.InvalidDestinationException;
import org.springframework.jms.InvalidSelectorException;
import org.springframework.jms.JmsException;
import org.springframework.jms.JmsSecurityException;
import org.springframework.jms.MessageEOFException;
import org.springframework.jms.MessageFormatException;
import org.springframework.jms.MessageNotReadableException;
import org.springframework.jms.MessageNotWriteableException;
import org.springframework.jms.ResourceAllocationException;
import org.springframework.jms.TransactionInProgressException;
import org.springframework.jms.TransactionRolledBackException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class JmsUtils {
    private static final Log logger = LogFactory.getLog(JmsUtils.class);

    public static void closeConnection(@Nullable Connection con) {
        JmsUtils.closeConnection(con, false);
    }

    public static void closeConnection(@Nullable Connection con, boolean stop) {
        block9: {
            if (con != null) {
                try {
                    if (stop) {
                        try {
                            con.stop();
                            break block9;
                        }
                        finally {
                            con.close();
                        }
                    }
                    con.close();
                }
                catch (jakarta.jms.IllegalStateException ex) {
                    logger.debug((Object)("Ignoring Connection state exception - assuming already closed: " + ex));
                }
                catch (JMSException ex) {
                    logger.debug((Object)"Could not close JMS Connection", (Throwable)ex);
                }
                catch (Throwable ex) {
                    logger.debug((Object)"Unexpected exception on closing JMS Connection", ex);
                }
            }
        }
    }

    public static void closeSession(@Nullable Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS Session", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS Session", ex);
            }
        }
    }

    public static void closeMessageProducer(@Nullable MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS MessageProducer", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS MessageProducer", ex);
            }
        }
    }

    public static void closeMessageConsumer(@Nullable MessageConsumer consumer) {
        if (consumer != null) {
            boolean wasInterrupted = Thread.interrupted();
            try {
                consumer.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS MessageConsumer", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS MessageConsumer", ex);
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static void closeQueueBrowser(@Nullable QueueBrowser browser) {
        if (browser != null) {
            try {
                browser.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS QueueBrowser", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS QueueBrowser", ex);
            }
        }
    }

    public static void closeQueueRequestor(@Nullable QueueRequestor requestor) {
        if (requestor != null) {
            try {
                requestor.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS QueueRequestor", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS QueueRequestor", ex);
            }
        }
    }

    public static void commitIfNecessary(Session session) throws JMSException {
        Assert.notNull((Object)session, (String)"Session must not be null");
        try {
            session.commit();
        }
        catch (jakarta.jms.IllegalStateException | jakarta.jms.TransactionInProgressException throwable) {
            // empty catch block
        }
    }

    public static void rollbackIfNecessary(Session session) throws JMSException {
        Assert.notNull((Object)session, (String)"Session must not be null");
        try {
            session.rollback();
        }
        catch (jakarta.jms.IllegalStateException | jakarta.jms.TransactionInProgressException throwable) {
            // empty catch block
        }
    }

    public static String buildExceptionMessage(JMSException ex) {
        Object message = ex.getMessage();
        Exception linkedEx = ex.getLinkedException();
        if (linkedEx != null) {
            if (message == null) {
                message = linkedEx.toString();
            } else {
                String linkedMessage = linkedEx.getMessage();
                if (linkedMessage != null && !((String)message).contains(linkedMessage)) {
                    message = (String)message + "; nested exception is " + linkedEx;
                }
            }
        }
        return message;
    }

    public static JmsException convertJmsAccessException(JMSException ex) {
        Assert.notNull((Object)((Object)ex), (String)"JMSException must not be null");
        if (ex instanceof jakarta.jms.IllegalStateException) {
            return new IllegalStateException((jakarta.jms.IllegalStateException)((Object)ex));
        }
        if (ex instanceof jakarta.jms.InvalidClientIDException) {
            return new InvalidClientIDException((jakarta.jms.InvalidClientIDException)ex);
        }
        if (ex instanceof jakarta.jms.InvalidDestinationException) {
            return new InvalidDestinationException((jakarta.jms.InvalidDestinationException)ex);
        }
        if (ex instanceof jakarta.jms.InvalidSelectorException) {
            return new InvalidSelectorException((jakarta.jms.InvalidSelectorException)ex);
        }
        if (ex instanceof JMSSecurityException) {
            return new JmsSecurityException((JMSSecurityException)ex);
        }
        if (ex instanceof jakarta.jms.MessageEOFException) {
            return new MessageEOFException((jakarta.jms.MessageEOFException)ex);
        }
        if (ex instanceof jakarta.jms.MessageFormatException) {
            return new MessageFormatException((jakarta.jms.MessageFormatException)ex);
        }
        if (ex instanceof jakarta.jms.MessageNotReadableException) {
            return new MessageNotReadableException((jakarta.jms.MessageNotReadableException)ex);
        }
        if (ex instanceof jakarta.jms.MessageNotWriteableException) {
            return new MessageNotWriteableException((jakarta.jms.MessageNotWriteableException)ex);
        }
        if (ex instanceof jakarta.jms.ResourceAllocationException) {
            return new ResourceAllocationException((jakarta.jms.ResourceAllocationException)ex);
        }
        if (ex instanceof jakarta.jms.TransactionInProgressException) {
            return new TransactionInProgressException((jakarta.jms.TransactionInProgressException)((Object)ex));
        }
        if (ex instanceof jakarta.jms.TransactionRolledBackException) {
            return new TransactionRolledBackException((jakarta.jms.TransactionRolledBackException)ex);
        }
        return new UncategorizedJmsException(ex);
    }
}

