/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryPlusOperations;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerPlusOperations;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractEntityManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
EntityManagerFactoryInfo,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceProvider persistenceProvider;
    private String persistenceUnitName;
    private JpaVendorAdapter jpaVendorAdapter;
    private final Map jpaPropertyMap = new HashMap();
    private Class entityManagerInterface;
    private JpaDialect jpaDialect;
    public EntityManagerFactory nativeEntityManagerFactory;
    private EntityManagerFactory entityManagerFactory;

    public void setPersistenceProviderClass(Class persistenceProviderClass) {
        Assert.notNull((Object)persistenceProviderClass, (String)"persistenceProviderClass must not be null");
        Assert.isTrue((boolean)PersistenceProvider.class.isAssignableFrom(persistenceProviderClass), (String)"serviceFactoryClass must implement [javax.persistence.spi.PersistenceProvider]");
        this.persistenceProvider = (PersistenceProvider)BeanUtils.instantiateClass((Class)persistenceProviderClass);
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaVendorAdapter(JpaVendorAdapter jpaVendorAdapter) {
        this.jpaVendorAdapter = jpaVendorAdapter;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)jpaProperties, (Map)this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setEntityManagerInterface(Class entityManagerInterface) {
        this.entityManagerInterface = entityManagerInterface;
    }

    public Class getEntityManagerInterface() {
        return this.entityManagerInterface;
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect;
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public final void afterPropertiesSet() throws PersistenceException {
        if (this.jpaVendorAdapter != null) {
            Map vendorPropertyMap;
            if (this.persistenceProvider == null) {
                this.persistenceProvider = this.jpaVendorAdapter.getPersistenceProvider();
            }
            if ((vendorPropertyMap = this.jpaVendorAdapter.getJpaPropertyMap()) != null) {
                for (Map.Entry entry : vendorPropertyMap.entrySet()) {
                    if (this.jpaPropertyMap.containsKey(entry.getKey())) continue;
                    this.jpaPropertyMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = this.jpaVendorAdapter.getEntityManagerInterface();
            }
            if (this.jpaDialect == null) {
                this.jpaDialect = this.jpaVendorAdapter.getJpaDialect();
            }
        } else if (this.entityManagerInterface == null) {
            this.entityManagerInterface = EntityManager.class;
        }
        this.nativeEntityManagerFactory = this.createNativeEntityManagerFactory();
        if (this.jpaVendorAdapter != null) {
            this.jpaVendorAdapter.postProcessEntityManagerFactory(this.nativeEntityManagerFactory);
        }
        this.entityManagerFactory = this.createEntityManagerFactoryProxy(this.nativeEntityManagerFactory);
    }

    protected abstract EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException;

    protected EntityManagerFactory createEntityManagerFactoryProxy(EntityManagerFactory emf) {
        Object[] ifcs = ClassUtils.getAllInterfaces((Object)emf);
        ifcs = (Class[])ObjectUtils.addObjectToArray((Object[])ifcs, EntityManagerFactoryInfo.class);
        EntityManagerFactoryPlusOperations plusOperations = null;
        if (this.getJpaDialect() != null && this.getJpaDialect().supportsEntityManagerFactoryPlusOperations()) {
            plusOperations = this.getJpaDialect().getEntityManagerFactoryPlusOperations(emf);
            ifcs = (Class[])ObjectUtils.addObjectToArray((Object[])ifcs, EntityManagerFactoryPlusOperations.class);
        }
        return (EntityManagerFactory)Proxy.newProxyInstance(this.getClass().getClassLoader(), ifcs, (InvocationHandler)new ManagedEntityManagerFactoryInvocationHandler(emf, this, plusOperations));
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.jpaDialect != null ? this.jpaDialect.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    public EntityManagerFactory getNativeEntityManagerFactory() {
        return this.nativeEntityManagerFactory;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return null;
    }

    public DataSource getDataSource() {
        return null;
    }

    public EntityManagerFactory getObject() {
        return this.entityManagerFactory;
    }

    public Class getObjectType() {
        return this.entityManagerFactory != null ? this.entityManagerFactory.getClass() : EntityManagerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Closing JPA EntityManagerFactory");
        this.entityManagerFactory.close();
    }

    private static class ManagedEntityManagerFactoryInvocationHandler
    implements InvocationHandler {
        private final EntityManagerFactory targetEntityManagerFactory;
        private final EntityManagerFactoryInfo entityManagerFactoryInfo;
        private final EntityManagerFactoryPlusOperations entityManagerFactoryPlusOperations;
        private final JpaDialect jpaDialect;

        public ManagedEntityManagerFactoryInvocationHandler(EntityManagerFactory targetEmf, EntityManagerFactoryInfo emfInfo, EntityManagerFactoryPlusOperations entityManagerFactoryPlusOperations) {
            this.targetEntityManagerFactory = targetEmf;
            this.entityManagerFactoryInfo = emfInfo;
            this.entityManagerFactoryPlusOperations = entityManagerFactoryPlusOperations;
            this.jpaDialect = emfInfo.getJpaDialect();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass().isAssignableFrom(EntityManagerFactoryInfo.class)) {
                    return method.invoke((Object)this.entityManagerFactoryInfo, args);
                }
                if (method.getDeclaringClass().equals(EntityManagerFactoryPlusOperations.class)) {
                    return method.invoke((Object)this.entityManagerFactoryPlusOperations, args);
                }
                Object retVal = method.invoke((Object)this.targetEntityManagerFactory, args);
                if (retVal instanceof EntityManager) {
                    EntityManager rawEntityManager = (EntityManager)retVal;
                    EntityManagerPlusOperations plusOperations = null;
                    if (this.jpaDialect != null && this.jpaDialect.supportsEntityManagerPlusOperations()) {
                        plusOperations = this.jpaDialect.getEntityManagerPlusOperations(rawEntityManager);
                    }
                    retVal = ExtendedEntityManagerCreator.createApplicationManagedEntityManager(rawEntityManager, plusOperations);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

