/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.lang.instrument.ClassFileTransformer;
import javax.persistence.spi.ClassTransformer;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.util.ClassUtils;

class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    private LoadTimeWeaver loadTimeWeaver;

    SpringPersistenceUnitInfo() {
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public ClassLoader getClassLoader() {
        if (this.loadTimeWeaver != null) {
            return this.loadTimeWeaver.getInstrumentableClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver == null) {
            throw new IllegalStateException("Cannot apply class transformer without LoadTimeWeaver specified");
        }
        this.loadTimeWeaver.addTransformer((ClassFileTransformer)new ClassFileTransformerAdapter(classTransformer));
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.loadTimeWeaver != null) {
            return this.loadTimeWeaver.getThrowawayClassLoader();
        }
        return new SimpleThrowawayClassLoader(ClassUtils.getDefaultClassLoader());
    }
}

