/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.ldap.BadLdapGrammarException;
import org.springframework.ldap.support.DefaultDnParserFactory;
import org.springframework.ldap.support.DnParser;
import org.springframework.ldap.support.LdapRdnComponent;
import org.springframework.ldap.support.ParseException;
import org.springframework.ldap.support.TokenMgrError;
import org.springframework.ldap.util.ListComparator;

public class LdapRdn
implements Serializable,
Comparable {
    private static final long serialVersionUID = 5681397547245228750L;
    private List components = new LinkedList();

    public LdapRdn() {
    }

    public LdapRdn(String string) {
        LdapRdn rdn;
        DnParser parser = DefaultDnParserFactory.createDnParser(string);
        try {
            rdn = parser.rdn();
        }
        catch (ParseException e) {
            throw new BadLdapGrammarException("Failed to parse Rdn", e);
        }
        catch (TokenMgrError e) {
            throw new BadLdapGrammarException("Failed to parse Rdn", e);
        }
        this.components = rdn.components;
    }

    public LdapRdn(String key, String value) {
        this.components.add(new LdapRdnComponent(key, value));
    }

    public void addComponent(LdapRdnComponent rdnComponent) {
        this.components.add(rdnComponent);
    }

    public List getComponents() {
        return this.components;
    }

    public LdapRdnComponent getComponent() {
        return (LdapRdnComponent)this.components.get(0);
    }

    public LdapRdnComponent getComponent(int idx) {
        return (LdapRdnComponent)this.components.get(idx);
    }

    public String getLdapEncoded() {
        if (this.components.size() == 0) {
            throw new IndexOutOfBoundsException("No components in Rdn.");
        }
        StringBuffer sb = new StringBuffer(100);
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            LdapRdnComponent component = (LdapRdnComponent)iter.next();
            sb.append(component.encodeLdap());
            if (!iter.hasNext()) continue;
            sb.append("+");
        }
        return sb.toString();
    }

    public String encodeUrl() {
        StringBuffer sb = new StringBuffer(100);
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            LdapRdnComponent component = (LdapRdnComponent)iter.next();
            sb.append(component.encodeUrl());
            if (!iter.hasNext()) continue;
            sb.append("+");
        }
        return sb.toString();
    }

    public int compareTo(Object obj) {
        LdapRdn that = (LdapRdn)obj;
        ListComparator comparator = new ListComparator();
        return comparator.compare(this.components, that.components);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LdapRdn that = (LdapRdn)obj;
        return ((Object)this.getComponents()).equals(that.getComponents());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ ((Object)this.getComponents()).hashCode();
    }

    public String toString() {
        return this.getLdapEncoded();
    }
}

