/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.ldap.support.filter.EqualsFilter;

public class WhitespaceWildcardsFilter
extends EqualsFilter {
    private static Pattern starReplacePattern = Pattern.compile("\\s+");

    public WhitespaceWildcardsFilter(String attribute, String value) {
        super(attribute, value);
    }

    protected String encodeValue(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "*";
        }
        value = value.trim();
        String filterEncoded = LdapEncoder.filterEncode(value);
        Matcher m = starReplacePattern.matcher(filterEncoded);
        StringBuffer buff = new StringBuffer(value.length() + 2);
        buff.append('*');
        while (m.find()) {
            m.appendReplacement(buff, "*");
        }
        m.appendTail(buff);
        buff.append('*');
        return buff.toString();
    }
}

