/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.core.AbstractDestinationResolvingMessagingTemplate;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class GenericMessagingTemplate
extends AbstractDestinationResolvingMessagingTemplate<MessageChannel>
implements BeanFactoryAware {
    private volatile long sendTimeout = -1L;
    private volatile long receiveTimeout = -1L;
    private volatile boolean throwExceptionOnLateReply = false;

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setThrowExceptionOnLateReply(boolean throwExceptionOnLateReply) {
        this.throwExceptionOnLateReply = throwExceptionOnLateReply;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setDestinationResolver(new BeanFactoryMessageChannelDestinationResolver(beanFactory));
    }

    @Override
    protected final void doSend(MessageChannel channel, Message<?> message) {
        boolean sent;
        Assert.notNull((Object)channel, (String)"channel must not be null");
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? channel.send(message, timeout) : channel.send(message);
        if (!sent) {
            throw new MessageDeliveryException(message, "failed to send message to channel '" + channel + "' within timeout: " + timeout);
        }
    }

    @Override
    protected final Message<?> doReceive(MessageChannel channel) {
        Message<?> message;
        Assert.notNull((Object)channel, (String)"'channel' is required");
        Assert.state((boolean)(channel instanceof PollableChannel), (String)"A PollableChannel is required to receive messages.");
        long timeout = this.receiveTimeout;
        Message<?> message2 = message = timeout >= 0L ? ((PollableChannel)channel).receive(timeout) : ((PollableChannel)channel).receive();
        if (message == null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Failed to receive message from channel '" + channel + "' within timeout: " + timeout));
        }
        return message;
    }

    @Override
    protected final Message<?> doSendAndReceive(MessageChannel channel, Message<?> requestMessage) {
        Assert.notNull((Object)channel, (String)"'channel' is required");
        Object originalReplyChannelHeader = requestMessage.getHeaders().getReplyChannel();
        Object originalErrorChannelHeader = requestMessage.getHeaders().getErrorChannel();
        TemporaryReplyChannel tempReplyChannel = new TemporaryReplyChannel();
        requestMessage = MessageBuilder.fromMessage(requestMessage).setReplyChannel(tempReplyChannel).setErrorChannel(tempReplyChannel).build();
        try {
            this.doSend(channel, requestMessage);
        }
        catch (RuntimeException e) {
            tempReplyChannel.setSendFailed(true);
            throw e;
        }
        Message<?> replyMessage = this.doReceive(tempReplyChannel);
        if (replyMessage != null) {
            replyMessage = MessageBuilder.fromMessage(replyMessage).setHeader("replyChannel", originalReplyChannelHeader).setHeader("errorChannel", originalErrorChannelHeader).build();
        }
        return replyMessage;
    }

    private class TemporaryReplyChannel
    implements PollableChannel {
        private final Log logger = LogFactory.getLog(TemporaryReplyChannel.class);
        private volatile Message<?> replyMessage;
        private final CountDownLatch replyLatch = new CountDownLatch(1);
        private volatile boolean hasReceived;
        private volatile boolean hasTimedOut;
        private volatile boolean hasSendFailed;

        private TemporaryReplyChannel() {
        }

        public void setSendFailed(boolean hasSendError) {
            this.hasSendFailed = hasSendError;
        }

        @Override
        public Message<?> receive() {
            return this.receive(-1L);
        }

        @Override
        public Message<?> receive(long timeout) {
            try {
                if (GenericMessagingTemplate.this.receiveTimeout < 0L) {
                    this.replyLatch.await();
                    this.hasReceived = true;
                } else if (this.replyLatch.await(GenericMessagingTemplate.this.receiveTimeout, TimeUnit.MILLISECONDS)) {
                    this.hasReceived = true;
                } else {
                    this.hasTimedOut = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.replyMessage;
        }

        @Override
        public boolean send(Message<?> message) {
            return this.send(message, -1L);
        }

        @Override
        public boolean send(Message<?> message, long timeout) {
            this.replyMessage = message;
            boolean alreadyReceivedReply = this.hasReceived;
            this.replyLatch.countDown();
            String errorDescription = null;
            if (this.hasTimedOut) {
                errorDescription = "Reply message received but the receiving thread has exited due to a timeout";
            } else if (alreadyReceivedReply) {
                errorDescription = "Reply message received but the receiving thread has already received a reply";
            } else if (this.hasSendFailed) {
                errorDescription = "Reply message received but the receiving thread has exited due to an exception while sending the request message";
            }
            if (errorDescription != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)(errorDescription + ":" + message));
                }
                if (GenericMessagingTemplate.this.throwExceptionOnLateReply) {
                    throw new MessageDeliveryException(message, errorDescription);
                }
            }
            return true;
        }
    }
}

