/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Collection;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.DefaultSubscriptionRegistry;
import org.springframework.messaging.simp.broker.SubscriptionRegistry;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;

public class SimpleBrokerMessageHandler
extends AbstractBrokerMessageHandler {
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private final SubscribableChannel brokerChannel;
    private SubscriptionRegistry subscriptionRegistry;
    private PathMatcher pathMatcher;
    private MessageHeaderInitializer headerInitializer;

    public SimpleBrokerMessageHandler(SubscribableChannel inChannel, MessageChannel outChannel, SubscribableChannel brokerChannel, Collection<String> destinationPrefixes) {
        super(destinationPrefixes);
        Assert.notNull((Object)inChannel, (String)"'clientInboundChannel' must not be null");
        Assert.notNull((Object)outChannel, (String)"'clientOutboundChannel' must not be null");
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        this.clientInboundChannel = inChannel;
        this.clientOutboundChannel = outChannel;
        this.brokerChannel = brokerChannel;
        DefaultSubscriptionRegistry subscriptionRegistry = new DefaultSubscriptionRegistry();
        this.subscriptionRegistry = subscriptionRegistry;
    }

    public SubscribableChannel getClientInboundChannel() {
        return this.clientInboundChannel;
    }

    public MessageChannel getClientOutboundChannel() {
        return this.clientOutboundChannel;
    }

    public SubscribableChannel getBrokerChannel() {
        return this.brokerChannel;
    }

    public void setSubscriptionRegistry(SubscriptionRegistry subscriptionRegistry) {
        Assert.notNull((Object)subscriptionRegistry, (String)"SubscriptionRegistry must not be null");
        this.subscriptionRegistry = subscriptionRegistry;
        this.initPathMatcherToUse();
    }

    private void initPathMatcherToUse() {
        if (this.pathMatcher != null && this.subscriptionRegistry instanceof DefaultSubscriptionRegistry) {
            ((DefaultSubscriptionRegistry)this.subscriptionRegistry).setPathMatcher(this.pathMatcher);
        }
    }

    public SubscriptionRegistry getSubscriptionRegistry() {
        return this.subscriptionRegistry;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
        this.initPathMatcherToUse();
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    @Override
    public void startInternal() {
        this.publishBrokerAvailableEvent();
        this.clientInboundChannel.subscribe(this);
        this.brokerChannel.subscribe(this);
    }

    @Override
    public void stopInternal() {
        this.publishBrokerUnavailableEvent();
        this.clientInboundChannel.unsubscribe(this);
        this.brokerChannel.unsubscribe(this);
    }

    @Override
    protected void handleMessageInternal(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        SimpMessageType messageType = SimpMessageHeaderAccessor.getMessageType(headers);
        String destination = SimpMessageHeaderAccessor.getDestination(headers);
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (!this.checkDestinationPrefix(destination)) {
            return;
        }
        SimpMessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, SimpMessageHeaderAccessor.class);
        if (accessor == null) {
            throw new IllegalStateException("No header accessor (not using the SimpMessagingTemplate?): " + message);
        }
        if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing " + accessor.getShortLogMessage(message.getPayload())));
            }
            this.sendMessageToSubscribers(destination, message);
        } else if (SimpMessageType.CONNECT.equals((Object)messageType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing " + accessor.getShortLogMessage(EMPTY_PAYLOAD)));
            }
            SimpMessageHeaderAccessor connectAck = SimpMessageHeaderAccessor.create(SimpMessageType.CONNECT_ACK);
            this.initHeaders(connectAck);
            connectAck.setSessionId(sessionId);
            connectAck.setHeader("simpConnectMessage", message);
            Message<byte[]> messageOut = MessageBuilder.createMessage(EMPTY_PAYLOAD, connectAck.getMessageHeaders());
            this.clientOutboundChannel.send(messageOut);
        } else if (SimpMessageType.DISCONNECT.equals((Object)messageType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing " + accessor.getShortLogMessage(EMPTY_PAYLOAD)));
            }
            this.subscriptionRegistry.unregisterAllSubscriptions(sessionId);
        } else if (SimpMessageType.SUBSCRIBE.equals((Object)messageType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing " + accessor.getShortLogMessage(EMPTY_PAYLOAD)));
            }
            this.subscriptionRegistry.registerSubscription(message);
        } else if (SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing " + accessor.getShortLogMessage(EMPTY_PAYLOAD)));
            }
            this.subscriptionRegistry.unregisterSubscription(message);
        }
    }

    private void initHeaders(SimpMessageHeaderAccessor accessor) {
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(accessor);
        }
    }

    protected void sendMessageToSubscribers(String destination, Message<?> message) {
        MultiValueMap<String, String> subscriptions = this.subscriptionRegistry.findSubscriptions(message);
        if (subscriptions.size() > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Broadcasting to " + subscriptions.size() + " sessions."));
        }
        for (String sessionId : subscriptions.keySet()) {
            for (String subscriptionId : (List)subscriptions.get((Object)sessionId)) {
                SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create(SimpMessageType.MESSAGE);
                this.initHeaders(headerAccessor);
                headerAccessor.setSessionId(sessionId);
                headerAccessor.setSubscriptionId(subscriptionId);
                headerAccessor.copyHeadersIfAbsent(message.getHeaders());
                Object payload = message.getPayload();
                Message<?> reply = MessageBuilder.createMessage(payload, headerAccessor.getMessageHeaders());
                try {
                    this.clientOutboundChannel.send(reply);
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Failed to send " + message), ex);
                }
            }
        }
    }

    public String toString() {
        return "SimpleBroker[" + this.subscriptionRegistry + "]";
    }
}

