/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support.reactive;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.codec.Decoder;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.CompositeMessageCondition;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.reactive.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.reactive.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.reactive.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.reactive.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.reactive.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodReturnValueHandler;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.Validator;
import reactor.core.publisher.Mono;

public class MessageMappingMessageHandler
extends AbstractMethodMessageHandler<CompositeMessageCondition>
implements EmbeddedValueResolverAware {
    @Nullable
    private Predicate<Class<?>> handlerPredicate = beanType -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanType, Controller.class);
    private final List<Decoder<?>> decoders = new ArrayList();
    @Nullable
    private Validator validator;
    private PathMatcher pathMatcher;
    private ConversionService conversionService = new DefaultFormattingConversionService();
    @Nullable
    private StringValueResolver valueResolver;

    public MessageMappingMessageHandler() {
        this.pathMatcher = new AntPathMatcher();
        ((AntPathMatcher)this.pathMatcher).setPathSeparator(".");
    }

    public void setHandlers(List<Object> handlers) {
        for (Object handler : handlers) {
            this.detectHandlerMethods(handler);
        }
        this.handlerPredicate = null;
    }

    public void setHandlerPredicate(@Nullable Predicate<Class<?>> handlerPredicate) {
        this.handlerPredicate = handlerPredicate;
    }

    @Nullable
    public Predicate<Class<?>> getHandlerPredicate() {
        return this.handlerPredicate;
    }

    public void setAutoDetectDisabled() {
        this.handlerPredicate = null;
    }

    public void setDecoders(List<? extends Decoder<?>> decoders) {
        this.decoders.addAll(decoders);
    }

    public List<? extends Decoder<?>> getDecoders() {
        return this.decoders;
    }

    public void setValidator(@Nullable Validator validator) {
        this.validator = validator;
    }

    @Nullable
    public Validator getValidator() {
        return this.validator;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.valueResolver = resolver;
    }

    @Override
    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        ApplicationContext context = this.getApplicationContext();
        ConfigurableListableBeanFactory beanFactory = context instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)context).getBeanFactory() : null;
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, (ConfigurableBeanFactory)beanFactory));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new DestinationVariableMethodArgumentResolver(this.conversionService));
        resolvers.addAll(this.getArgumentResolverConfigurer().getCustomResolvers());
        resolvers.add(new PayloadMethodArgumentResolver(this.decoders, this.validator, this.getReactiveAdapterRegistry(), true));
        return resolvers;
    }

    @Override
    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return Collections.emptyList();
    }

    @Override
    protected Predicate<Class<?>> initHandlerPredicate() {
        return this.handlerPredicate;
    }

    @Override
    protected CompositeMessageCondition getMappingForMethod(Method method, Class<?> handlerType) {
        CompositeMessageCondition typeCondition;
        CompositeMessageCondition methodCondition = this.getCondition(method);
        if (methodCondition != null && (typeCondition = this.getCondition(handlerType)) != null) {
            return typeCondition.combine(methodCondition);
        }
        return methodCondition;
    }

    @Nullable
    private CompositeMessageCondition getCondition(AnnotatedElement element) {
        MessageMapping annot = (MessageMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, MessageMapping.class);
        if (annot == null || annot.value().length == 0) {
            return null;
        }
        String[] destinations = annot.value();
        if (this.valueResolver != null) {
            destinations = (String[])Arrays.stream(annot.value()).map(s -> this.valueResolver.resolveStringValue(s)).toArray(String[]::new);
        }
        return new CompositeMessageCondition(new DestinationPatternsMessageCondition(destinations, this.pathMatcher));
    }

    @Override
    protected Set<String> getDirectLookupMappings(CompositeMessageCondition mapping) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String pattern : mapping.getCondition(DestinationPatternsMessageCondition.class).getPatterns()) {
            if (this.pathMatcher.isPattern(pattern)) continue;
            result.add(pattern);
        }
        return result;
    }

    @Override
    protected String getDestination(Message<?> message) {
        return (String)message.getHeaders().get("lookupDestination");
    }

    @Override
    protected CompositeMessageCondition getMatchingMapping(CompositeMessageCondition mapping, Message<?> message) {
        return mapping.getMatchingCondition((Message)message);
    }

    @Override
    protected Comparator<CompositeMessageCondition> getMappingComparator(Message<?> message) {
        return (info1, info2) -> info1.compareTo((CompositeMessageCondition)info2, message);
    }

    @Override
    protected AbstractExceptionHandlerMethodResolver createExceptionMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    @Override
    protected Mono<Void> handleMatch(CompositeMessageCondition mapping, HandlerMethod handlerMethod, Message<?> message) {
        Set<String> patterns = mapping.getCondition(DestinationPatternsMessageCondition.class).getPatterns();
        if (!CollectionUtils.isEmpty(patterns)) {
            String pattern = patterns.iterator().next();
            String destination = this.getDestination(message);
            Map vars = this.getPathMatcher().extractUriTemplateVariables(pattern, destination);
            if (!CollectionUtils.isEmpty((Map)vars)) {
                MessageHeaderAccessor mha = MessageHeaderAccessor.getAccessor(message, MessageHeaderAccessor.class);
                Assert.state((mha != null && mha.isMutable() ? 1 : 0) != 0, (String)"Mutable MessageHeaderAccessor required");
                mha.setHeader(DestinationVariableMethodArgumentResolver.DESTINATION_TEMPLATE_VARIABLES_HEADER, vars);
            }
        }
        return super.handleMatch(mapping, handlerMethod, message);
    }
}

