/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.rsocket.ConnectionSetupPayload;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.MessagingRSocket;
import org.springframework.messaging.rsocket.RSocketMessageHandler;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

public final class MessageHandlerAcceptor
extends RSocketMessageHandler
implements SocketAcceptor,
Function<RSocket, RSocket> {
    @Nullable
    private MimeType defaultDataMimeType;

    public void setDefaultDataMimeType(@Nullable MimeType defaultDataMimeType) {
        this.defaultDataMimeType = defaultDataMimeType;
    }

    public Mono<RSocket> accept(ConnectionSetupPayload setupPayload, RSocket sendingRSocket) {
        MessagingRSocket rsocket = this.createRSocket(sendingRSocket);
        return rsocket.handleConnectionSetupPayload(setupPayload).then(Mono.just((Object)((Object)rsocket)));
    }

    @Override
    public RSocket apply(RSocket sendingRSocket) {
        return this.createRSocket(sendingRSocket);
    }

    private MessagingRSocket createRSocket(RSocket rsocket) {
        return new MessagingRSocket(this::handleMessage, rsocket, this.defaultDataMimeType, this.getRSocketStrategies());
    }
}

