/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.handler.annotation.reactive.MessageMappingMessageHandler;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodReturnValueHandler;
import org.springframework.messaging.rsocket.RSocketPayloadReturnValueHandler;
import org.springframework.messaging.rsocket.RSocketRequesterMethodArgumentResolver;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RSocketMessageHandler
extends MessageMappingMessageHandler {
    private final List<Encoder<?>> encoders = new ArrayList();
    @Nullable
    private RSocketStrategies rsocketStrategies;

    public void setEncoders(List<? extends Encoder<?>> encoders) {
        this.encoders.addAll(encoders);
    }

    public List<? extends Encoder<?>> getEncoders() {
        return this.encoders;
    }

    public void setRSocketStrategies(RSocketStrategies rsocketStrategies) {
        Assert.notNull((Object)rsocketStrategies, (String)"RSocketStrategies must not be null");
        this.rsocketStrategies = rsocketStrategies;
        this.setDecoders(rsocketStrategies.decoders());
        this.setEncoders(rsocketStrategies.encoders());
        this.setReactiveAdapterRegistry(rsocketStrategies.reactiveAdapterRegistry());
    }

    public RSocketStrategies getRSocketStrategies() {
        if (this.rsocketStrategies == null) {
            this.rsocketStrategies = RSocketStrategies.builder().decoder(this.getDecoders().toArray(new Decoder[0])).encoder(this.getEncoders().toArray(new Encoder[0])).reactiveAdapterStrategy(this.getReactiveAdapterRegistry()).build();
        }
        return this.rsocketStrategies;
    }

    @Override
    public void afterPropertiesSet() {
        this.getArgumentResolverConfigurer().addCustomResolver(new RSocketRequesterMethodArgumentResolver());
        super.afterPropertiesSet();
    }

    @Override
    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>();
        handlers.add(new RSocketPayloadReturnValueHandler(this.encoders, this.getReactiveAdapterRegistry()));
        handlers.addAll(this.getReturnValueHandlerConfigurer().getCustomHandlers());
        return handlers;
    }

    @Override
    protected void handleNoMatch(@Nullable String destination, Message<?> message) {
        if (StringUtils.hasText((String)destination)) {
            throw new MessageDeliveryException("No handler for destination '" + destination + "'");
        }
    }
}

