/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.transport.ClientTransport;
import java.net.URI;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.DefaultRSocketRequester;
import org.springframework.messaging.rsocket.DefaultRSocketRequesterBuilder;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface RSocketRequester {
    public RSocket rsocket();

    public MimeType dataMimeType();

    public MimeType metadataMimeType();

    public RequestSpec route(String var1);

    public static Builder builder() {
        return new DefaultRSocketRequesterBuilder();
    }

    public static RSocketRequester wrap(RSocket rsocket, MimeType dataMimeType, MimeType metadataMimeType, RSocketStrategies strategies) {
        return new DefaultRSocketRequester(rsocket, dataMimeType, metadataMimeType, strategies);
    }

    public static interface ResponseSpec {
        public Mono<Void> send();

        public <T> Mono<T> retrieveMono(Class<T> var1);

        public <T> Mono<T> retrieveMono(ParameterizedTypeReference<T> var1);

        public <T> Flux<T> retrieveFlux(Class<T> var1);

        public <T> Flux<T> retrieveFlux(ParameterizedTypeReference<T> var1);
    }

    public static interface RequestSpec {
        public RequestSpec metadata(Object var1, MimeType var2);

        public ResponseSpec data(Object var1);

        public <T, P extends Publisher<T>> ResponseSpec data(P var1, Class<T> var2);

        public <T, P extends Publisher<T>> ResponseSpec data(P var1, ParameterizedTypeReference<T> var2);
    }

    public static interface Builder {
        public Builder dataMimeType(@Nullable MimeType var1);

        public Builder metadataMimeType(MimeType var1);

        public Builder rsocketFactory(Consumer<RSocketFactory.ClientRSocketFactory> var1);

        public Builder rsocketStrategies(@Nullable RSocketStrategies var1);

        public Builder rsocketStrategies(Consumer<RSocketStrategies.Builder> var1);

        public Mono<RSocketRequester> connectTcp(String var1, int var2);

        public Mono<RSocketRequester> connectWebSocket(URI var1);

        public Mono<RSocketRequester> connect(ClientTransport var1);
    }
}

