/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.Session;
import org.springframework.orm.toplink.AbstractSessionFactory;

public class SessionBrokerSessionFactory
extends AbstractSessionFactory {
    private final SessionBroker sessionBroker;

    public SessionBrokerSessionFactory(SessionBroker broker) {
        this.sessionBroker = broker;
    }

    public Session createSession() throws TopLinkException {
        try {
            return this.createClientSession();
        }
        catch (ValidationException ex) {
            this.logger.debug((Object)"Could not create TopLink client session for SessionBroker - returning SessionBroker itself", (Throwable)ex);
            return this.getMasterSession();
        }
    }

    protected Session getMasterSession() {
        return this.sessionBroker;
    }

    protected Session createClientSession() throws TopLinkException {
        return this.sessionBroker.acquireClientSessionBroker();
    }

    public void close() {
        this.sessionBroker.logout();
        this.sessionBroker.release();
    }
}

