/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.async.AsyncWebUtils;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    protected boolean shouldFilterAsyncDispatches() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block8: {
            SessionFactory sessionFactory = this.lookupSessionFactory(request);
            boolean participate = false;
            WebAsyncManager asyncManager = AsyncWebUtils.getAsyncManager((ServletRequest)request);
            boolean isFirstRequest = !this.isAsyncDispatch(request);
            String key = this.getAlreadyFilteredAttributeName();
            if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                participate = true;
            } else if (isFirstRequest || !asyncManager.initializeAsyncThread((Object)key)) {
                this.logger.debug((Object)"Opening Hibernate Session in OpenSessionInViewFilter");
                Session session = this.openSession(sessionFactory);
                SessionHolder sessionHolder = new SessionHolder(session);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                WebAsyncManager.WebAsyncThreadInitializer initializer = this.createAsyncThreadInitializer(sessionFactory, sessionHolder);
                asyncManager.registerAsyncThreadInitializer((Object)key, initializer);
            }
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                Object var13_12 = null;
                if (participate) break block8;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (!participate) {
                    SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
                    if (this.isLastRequestThread(request)) {
                        this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewFilter");
                        SessionFactoryUtils.closeSession(sessionHolder.getSession());
                    }
                }
                throw throwable;
            }
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
            if (this.isLastRequestThread(request)) {
                this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewFilter");
                SessionFactoryUtils.closeSession(sessionHolder.getSession());
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }

    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        try {
            Session session = SessionFactoryUtils.openSession(sessionFactory);
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    private WebAsyncManager.WebAsyncThreadInitializer createAsyncThreadInitializer(final SessionFactory sessionFactory, final SessionHolder sessionHolder) {
        return new WebAsyncManager.WebAsyncThreadInitializer(){

            public void initialize() {
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
            }

            public void reset() {
                TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            }
        };
    }
}

