/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class MockClientHttpResponse
implements ClientHttpResponse {
    private InputStream body;
    private final HttpHeaders headers;
    private final HttpStatus status;

    public MockClientHttpResponse(byte[] body, HttpHeaders headers, HttpStatus statusCode) {
        this(MockClientHttpResponse.bodyAsInputStream(body), headers, statusCode);
    }

    private static InputStream bodyAsInputStream(byte[] body) {
        return body != null ? new ByteArrayInputStream(body) : null;
    }

    public MockClientHttpResponse(InputStream body, HttpHeaders headers, HttpStatus statusCode) {
        this.body = body;
        this.headers = headers;
        this.status = statusCode;
    }

    public InputStream getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.status;
    }

    public String getStatusText() throws IOException {
        return this.status.getReasonPhrase();
    }

    public int getRawStatusCode() throws IOException {
        return this.status.value();
    }

    public void close() {
    }
}

