/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.RequestBuilder;
import org.springframework.test.web.server.ResultActions;
import org.springframework.test.web.server.ResultHandler;
import org.springframework.test.web.server.ResultMatcher;
import org.springframework.test.web.server.TestDispatcherServlet;
import org.springframework.util.Assert;

public class MockMvc {
    private final TestDispatcherServlet dispatcherServlet;
    private final ServletContext servletContext;

    protected MockMvc(TestDispatcherServlet dispatcherServlet) {
        this.dispatcherServlet = dispatcherServlet;
        this.servletContext = this.dispatcherServlet.getServletContext();
        Assert.notNull((Object)this.servletContext, (String)"A ServletContext is required");
    }

    public ResultActions perform(RequestBuilder requestBuilder) throws Exception {
        MockHttpServletRequest request = requestBuilder.buildRequest(this.servletContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.dispatcherServlet.service((ServletRequest)request, (ServletResponse)response);
        final MvcResult result = this.dispatcherServlet.getMvcResult((HttpServletRequest)request);
        return new ResultActions(){

            public ResultActions andExpect(ResultMatcher matcher) throws Exception {
                matcher.match(result);
                return this;
            }

            public ResultActions andDo(ResultHandler printer) throws Exception {
                printer.handle(result);
                return this;
            }

            public MvcResult andReturn() {
                return result;
            }
        };
    }
}

